/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.util;

import conductor.org.elasticsearch.common.regex.Regex;
import java.net.URI;
import java.net.URISyntaxException;

public class URIPattern {
    private final URI uriPattern;

    public URIPattern(String pattern) {
        try {
            this.uriPattern = new URI(pattern);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("cannot parse URI pattern [" + pattern + "]");
        }
    }

    public boolean match(URI uri) {
        return this.matchNormalized(uri.normalize());
    }

    public static boolean match(URIPattern[] patterns, URI uri) {
        URI normalized = uri.normalize();
        for (URIPattern pattern : patterns) {
            if (!pattern.matchNormalized(normalized)) continue;
            return true;
        }
        return false;
    }

    private boolean matchNormalized(URI uri) {
        if (this.uriPattern.isOpaque()) {
            return uri.isOpaque() && this.match(this.uriPattern.getScheme(), uri.getScheme()) && this.match(this.uriPattern.getSchemeSpecificPart(), uri.getSchemeSpecificPart()) && this.match(this.uriPattern.getFragment(), uri.getFragment());
        }
        return this.match(this.uriPattern.getScheme(), uri.getScheme()) && this.match(this.uriPattern.getAuthority(), uri.getAuthority()) && this.match(this.uriPattern.getQuery(), uri.getQuery()) && this.match(this.uriPattern.getPath(), uri.getPath()) && this.match(this.uriPattern.getFragment(), uri.getFragment());
    }

    private boolean match(String pattern, String value) {
        if (value == null && (pattern == null || Regex.isMatchAllPattern(pattern))) {
            return true;
        }
        return Regex.simpleMatch(pattern, value);
    }

    public String toString() {
        return this.uriPattern.toString();
    }
}

