/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.standard.StandardAnalyzer;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import conductor.org.elasticsearch.index.analysis.Analysis;

public class StandardAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StandardAnalyzer> {
    private final StandardAnalyzer standardAnalyzer;

    public StandardAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        CharArraySet defaultStopwords = CharArraySet.EMPTY_SET;
        CharArraySet stopWords = Analysis.parseStopWords(env, indexSettings.getIndexVersionCreated(), settings, defaultStopwords);
        int maxTokenLength = settings.getAsInt("max_token_length", 255);
        this.standardAnalyzer = new StandardAnalyzer(stopWords);
        this.standardAnalyzer.setVersion(this.version);
        this.standardAnalyzer.setMaxTokenLength(maxTokenLength);
    }

    @Override
    public StandardAnalyzer get() {
        return this.standardAnalyzer;
    }
}

