/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.StopFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.core.StopAnalyzer;
import conductor.org.apache.lucene.search.suggest.analyzing.SuggestStopFilter;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import conductor.org.elasticsearch.index.analysis.Analysis;
import java.util.Set;

public class StopTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet stopWords;
    private final boolean ignoreCase;
    private final boolean removeTrailing;

    public StopTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.ignoreCase = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "ignore_case", false, this.deprecationLogger);
        this.removeTrailing = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "remove_trailing", true, this.deprecationLogger);
        this.stopWords = Analysis.parseStopWords(env, settings, StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase);
        if (settings.get("enable_position_increments") != null) {
            throw new IllegalArgumentException("enable_position_increments is not supported anymore. Please fix your analysis chain");
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.removeTrailing) {
            return new StopFilter(tokenStream, this.stopWords);
        }
        return new SuggestStopFilter(tokenStream, this.stopWords);
    }

    public Set<?> stopWords() {
        return this.stopWords;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }
}

