/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import conductor.org.apache.lucene.analysis.synonym.SynonymMap;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AnalysisRegistry;
import conductor.org.elasticsearch.index.analysis.CharFilterFactory;
import conductor.org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import conductor.org.elasticsearch.index.analysis.TokenFilterFactory;
import conductor.org.elasticsearch.index.analysis.TokenizerFactory;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public class SynonymGraphTokenFilterFactory
extends SynonymTokenFilterFactory {
    public SynonymGraphTokenFilterFactory(IndexSettings indexSettings, Environment env, AnalysisRegistry analysisRegistry, String name, Settings settings) throws IOException {
        super(indexSettings, env, analysisRegistry, name, settings);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymGraphFactory to specialize this factory for an analysis chain first");
    }

    @Override
    public TokenFilterFactory getChainAwareTokenFilterFactory(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        Analyzer analyzer = this.buildSynonymAnalyzer(tokenizer, charFilters, previousTokenFilters);
        final SynonymMap synonyms = this.buildSynonyms(analyzer, this.getRulesFromSettings(this.environment));
        final String name = this.name();
        return new TokenFilterFactory(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return synonyms.fst == null ? tokenStream : new SynonymGraphFilter(tokenStream, synonyms, SynonymGraphTokenFilterFactory.this.ignoreCase);
            }
        };
    }
}

