/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata;

import conductor.org.apache.lucene.util.ArrayUtil;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefBuilder;
import conductor.org.apache.lucene.util.InPlaceMergeSorter;
import conductor.org.apache.lucene.util.RamUsageEstimator;
import conductor.org.apache.lucene.util.Sorter;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import java.util.Arrays;

public abstract class SortingBinaryDocValues
extends SortedBinaryDocValues {
    private int index;
    protected int count;
    protected BytesRefBuilder[] values = new BytesRefBuilder[]{new BytesRefBuilder()};
    private final Sorter sorter = new InPlaceMergeSorter(){

        @Override
        protected void swap(int i, int j) {
            ArrayUtil.swap(SortingBinaryDocValues.this.values, i, j);
        }

        @Override
        protected int compare(int i, int j) {
            return SortingBinaryDocValues.this.values[i].get().compareTo(SortingBinaryDocValues.this.values[j].get());
        }
    };

    protected SortingBinaryDocValues() {
    }

    protected final void grow() {
        if (this.values.length < this.count) {
            int oldLen = this.values.length;
            int newLen = ArrayUtil.oversize(this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            this.values = Arrays.copyOf(this.values, newLen);
            for (int i = oldLen; i < newLen; ++i) {
                this.values[i] = new BytesRefBuilder();
            }
        }
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
        this.index = 0;
    }

    @Override
    public int docValueCount() {
        return this.count;
    }

    @Override
    public final BytesRef nextValue() {
        assert (this.index < this.count);
        return this.values[this.index++].get();
    }
}

