/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.percolator;

import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.mapper.Mapper;
import conductor.org.elasticsearch.percolator.PercolateQueryBuilder;
import conductor.org.elasticsearch.percolator.PercolatorFieldMapper;
import conductor.org.elasticsearch.percolator.PercolatorHighlightSubFetchPhase;
import conductor.org.elasticsearch.percolator.PercolatorMatchedSlotSubFetchPhase;
import conductor.org.elasticsearch.plugins.MapperPlugin;
import conductor.org.elasticsearch.plugins.Plugin;
import conductor.org.elasticsearch.plugins.SearchPlugin;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PercolatorPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    private final Settings settings;

    public PercolatorPlugin(Settings settings) {
        this.settings = settings;
    }

    @Override
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec<PercolateQueryBuilder>("percolate", PercolateQueryBuilder::new, PercolateQueryBuilder::fromXContent));
    }

    @Override
    public List<FetchSubPhase> getFetchSubPhases(SearchPlugin.FetchPhaseConstructionContext context) {
        return Arrays.asList(new PercolatorMatchedSlotSubFetchPhase(), new PercolatorHighlightSubFetchPhase(this.settings, context.getHighlighters()));
    }

    @Override
    public List<Setting<?>> getSettings() {
        return Arrays.asList(PercolatorFieldMapper.INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING, PercolatorFieldMapper.INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING);
    }

    @Override
    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("percolator", new PercolatorFieldMapper.TypeParser());
    }
}

