/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.persistent;

import conductor.org.elasticsearch.action.Action;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import conductor.org.elasticsearch.action.support.master.MasterNodeRequest;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.client.ElasticsearchClient;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.persistent.PersistentTaskResponse;
import conductor.org.elasticsearch.persistent.PersistentTaskState;
import conductor.org.elasticsearch.persistent.PersistentTasksClusterService;
import conductor.org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.Objects;

public class UpdatePersistentTaskStatusAction
extends Action<Request, PersistentTaskResponse, RequestBuilder> {
    public static final UpdatePersistentTaskStatusAction INSTANCE = new UpdatePersistentTaskStatusAction();
    public static final String NAME = "cluster:admin/persistent/update_status";

    private UpdatePersistentTaskStatusAction() {
        super(NAME);
    }

    @Override
    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    @Override
    public PersistentTaskResponse newResponse() {
        return new PersistentTaskResponse();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, UpdatePersistentTaskStatusAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.persistentTasksClusterService = persistentTasksClusterService;
        }

        @Override
        protected String executor() {
            return "management";
        }

        @Override
        protected PersistentTaskResponse newResponse() {
            return new PersistentTaskResponse();
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void masterOperation(Request request, ClusterState state, final ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.updatePersistentTaskState(request.taskId, request.allocationId, request.state, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                @Override
                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                    listener.onResponse(new PersistentTaskResponse(task));
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, UpdatePersistentTaskStatusAction action) {
            super(client, action, new Request());
        }

        public final RequestBuilder setTaskId(String taskId) {
            ((Request)this.request).setTaskId(taskId);
            return this;
        }

        public final RequestBuilder setState(PersistentTaskState state) {
            ((Request)this.request).setState(state);
            return this;
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String taskId;
        private long allocationId = -1L;
        private PersistentTaskState state;

        public Request() {
        }

        public Request(String taskId, long allocationId, PersistentTaskState state) {
            this.taskId = taskId;
            this.allocationId = allocationId;
            this.state = state;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public void setAllocationId(long allocationId) {
            this.allocationId = allocationId;
        }

        public void setState(PersistentTaskState state) {
            this.state = state;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.taskId = in.readString();
            this.allocationId = in.readLong();
            this.state = in.readOptionalNamedWriteable(PersistentTaskState.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeLong(this.allocationId);
            out.writeOptionalNamedWriteable(this.state);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError("task id must be specified", validationException);
            }
            if (this.allocationId == -1L) {
                validationException = ValidateActions.addValidationError("allocationId must be specified", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskId, request.taskId) && this.allocationId == request.allocationId && Objects.equals(this.state, request.state);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.allocationId, this.state);
        }
    }
}

