/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.search;

import conductor.org.elasticsearch.action.explain.ExplainRequest;
import conductor.org.elasticsearch.action.explain.ExplainResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestActions;
import conductor.org.elasticsearch.rest.action.RestStatusToXContentListener;
import conductor.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;

public class RestExplainAction
extends BaseRestHandler {
    public RestExplainAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_explain", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_explain", this);
    }

    @Override
    public String getName() {
        return "explain_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] sFields;
        ExplainRequest explainRequest = new ExplainRequest(request.param("index"), request.param("type"), request.param("id"));
        explainRequest.parent(request.param("parent"));
        explainRequest.routing(request.param("routing"));
        explainRequest.preference(request.param("preference"));
        String queryString = request.param("q");
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                explainRequest.query(RestActions.getQueryContent(parser));
            } else if (queryString != null) {
                QueryBuilder query = RestActions.urlParamsToQueryBuilder(request);
                explainRequest.query(query);
            }
        });
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields");
        }
        String sField = request.param("stored_fields");
        if (sField != null && (sFields = Strings.splitStringByCommaToArray(sField)) != null) {
            explainRequest.storedFields(sFields);
        }
        explainRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> client.explain(explainRequest, new RestStatusToXContentListener<ExplainResponse>((RestChannel)channel));
    }
}

