/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.geocentroid;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.geo.GeoPoint;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.LongArray;
import conductor.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import conductor.org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import conductor.org.elasticsearch.search.aggregations.metrics.geocentroid.InternalGeoCentroid;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class GeoCentroidAggregator
extends MetricsAggregator {
    private final ValuesSource.GeoPoint valuesSource;
    private LongArray centroids;
    private LongArray counts;

    GeoCentroidAggregator(String name, SearchContext context, Aggregator parent, ValuesSource.GeoPoint valuesSource, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.centroids = bigArrays.newLongArray(1L, true);
            this.counts = bigArrays.newLongArray(1L, true);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoPointValues values = this.valuesSource.geoPointValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                GeoCentroidAggregator.this.centroids = bigArrays.grow(GeoCentroidAggregator.this.centroids, bucket + 1L);
                GeoCentroidAggregator.this.counts = bigArrays.grow(GeoCentroidAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    double[] pt = new double[2];
                    long prevCounts = GeoCentroidAggregator.this.counts.get(bucket);
                    GeoCentroidAggregator.this.counts.increment(bucket, valueCount);
                    if (prevCounts > 0L) {
                        long mortonCode = GeoCentroidAggregator.this.centroids.get(bucket);
                        pt[0] = InternalGeoCentroid.decodeLongitude(mortonCode);
                        pt[1] = InternalGeoCentroid.decodeLatitude(mortonCode);
                    }
                    for (int i = 0; i < valueCount; ++i) {
                        GeoPoint value = values.nextValue();
                        pt[0] = pt[0] + (value.getLon() - pt[0]) / (double)(++prevCounts);
                        pt[1] = pt[1] + (value.getLat() - pt[1]) / (double)prevCounts;
                    }
                    GeoCentroidAggregator.this.centroids.set(bucket, InternalGeoCentroid.encodeLatLon(pt[1], pt[0]));
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.centroids.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        long mortonCode = this.centroids.get(bucket);
        GeoPoint bucketCentroid = bucketCount > 0L ? new GeoPoint(InternalGeoCentroid.decodeLatitude(mortonCode), InternalGeoCentroid.decodeLongitude(mortonCode)) : null;
        return new InternalGeoCentroid(this.name, bucketCentroid, bucketCount, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoCentroid(this.name, null, 0L, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.centroids, this.counts);
    }
}

