/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.github.mustachejava.reflect;

import conductor.com.github.mustachejava.reflect.Guard;
import conductor.com.github.mustachejava.util.GuardException;
import conductor.com.github.mustachejava.util.Wrapper;
import java.util.Arrays;
import java.util.List;

public class GuardedWrapper
implements Wrapper {
    protected static final GuardException guardException = new GuardException();
    protected final Guard[] guards;
    private int hashCode;

    public GuardedWrapper(Guard[] guards) {
        this.guards = guards;
    }

    @Override
    public Object call(List<Object> scopes) throws GuardException {
        this.guardCall(scopes);
        return null;
    }

    protected void guardCall(List<Object> scopes) throws GuardException {
        for (Guard predicate : this.guards) {
            if (predicate.apply(scopes)) continue;
            throw guardException;
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            for (Guard predicate : this.guards) {
                this.hashCode += this.hashCode * 43 + predicate.hashCode();
            }
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof GuardedWrapper) {
            GuardedWrapper other = (GuardedWrapper)o;
            return this.guards == null && other.guards == null || Arrays.equals(other.guards, this.guards);
        }
        return false;
    }

    public Guard[] getGuards() {
        return this.guards;
    }

    public String toString() {
        return "[GuardedWrapper: " + Arrays.asList(this.guards) + "]";
    }

    static {
        guardException.setStackTrace(new StackTraceElement[0]);
    }
}

