/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.impl.nio.conn;

import conductor.org.apache.commons.logging.Log;
import conductor.org.apache.commons.logging.LogFactory;
import conductor.org.apache.http.HttpRequest;
import conductor.org.apache.http.HttpResponse;
import conductor.org.apache.http.config.ConnectionConfig;
import conductor.org.apache.http.impl.nio.codecs.DefaultHttpRequestWriterFactory;
import conductor.org.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import conductor.org.apache.http.impl.nio.conn.ManagedNHttpClientConnectionImpl;
import conductor.org.apache.http.nio.NHttpMessageParserFactory;
import conductor.org.apache.http.nio.NHttpMessageWriterFactory;
import conductor.org.apache.http.nio.conn.ManagedNHttpClientConnection;
import conductor.org.apache.http.nio.conn.NHttpConnectionFactory;
import conductor.org.apache.http.nio.reactor.IOSession;
import conductor.org.apache.http.nio.util.ByteBufferAllocator;
import conductor.org.apache.http.nio.util.HeapByteBufferAllocator;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicLong;

public class ManagedNHttpClientConnectionFactory
implements NHttpConnectionFactory<ManagedNHttpClientConnection> {
    private final Log headerlog = LogFactory.getLog("conductor.org.apache.http.headers");
    private final Log wirelog = LogFactory.getLog("conductor.org.apache.http.wire");
    private final Log log = LogFactory.getLog(ManagedNHttpClientConnectionImpl.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    public static final ManagedNHttpClientConnectionFactory INSTANCE = new ManagedNHttpClientConnectionFactory();
    private final ByteBufferAllocator allocator;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;

    public ManagedNHttpClientConnectionFactory(NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory, ByteBufferAllocator allocator) {
        this.requestWriterFactory = requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
        this.responseParserFactory = responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE;
        this.allocator = allocator != null ? allocator : HeapByteBufferAllocator.INSTANCE;
    }

    public ManagedNHttpClientConnectionFactory() {
        this(null, null, null);
    }

    @Override
    public ManagedNHttpClientConnection create(IOSession iosession, ConnectionConfig config) {
        CodingErrorAction unmappableInputAction;
        String id = "http-outgoing-" + Long.toString(COUNTER.getAndIncrement());
        CharsetDecoder chardecoder = null;
        CharsetEncoder charencoder = null;
        Charset charset = config.getCharset();
        CodingErrorAction malformedInputAction = config.getMalformedInputAction() != null ? config.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction = unmappableInputAction = config.getUnmappableInputAction() != null ? config.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (charset != null) {
            chardecoder = charset.newDecoder();
            chardecoder.onMalformedInput(malformedInputAction);
            chardecoder.onUnmappableCharacter(unmappableInputAction);
            charencoder = charset.newEncoder();
            charencoder.onMalformedInput(malformedInputAction);
            charencoder.onUnmappableCharacter(unmappableInputAction);
        }
        ManagedNHttpClientConnectionImpl conn = new ManagedNHttpClientConnectionImpl(id, this.log, this.headerlog, this.wirelog, iosession, config.getBufferSize(), config.getFragmentSizeHint(), this.allocator, chardecoder, charencoder, config.getMessageConstraints(), null, null, this.requestWriterFactory, this.responseParserFactory);
        iosession.setAttribute("http.connection", conn);
        return conn;
    }
}

