/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.protocol;

import conductor.org.apache.http.HttpEntityEnclosingRequest;
import conductor.org.apache.http.HttpException;
import conductor.org.apache.http.HttpRequest;
import conductor.org.apache.http.HttpRequestInterceptor;
import conductor.org.apache.http.annotation.Contract;
import conductor.org.apache.http.annotation.ThreadingBehavior;
import conductor.org.apache.http.protocol.HttpContext;
import conductor.org.apache.http.protocol.HttpDateGenerator;
import conductor.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

