/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queries.function;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.DoubleValues;
import conductor.org.apache.lucene.search.DoubleValuesSource;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.FilterScorer;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Matches;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

public final class FunctionScoreQuery
extends Query {
    private final Query in;
    private final DoubleValuesSource source;

    public FunctionScoreQuery(Query in, DoubleValuesSource source) {
        this.in = in;
        this.source = source;
    }

    public Query getWrappedQuery() {
        return this.in;
    }

    public static FunctionScoreQuery boostByValue(Query in, DoubleValuesSource boost) {
        return new FunctionScoreQuery(in, new MultiplicativeBoostValuesSource(boost));
    }

    public static FunctionScoreQuery boostByQuery(Query in, Query boostMatch, float boostValue) {
        return new FunctionScoreQuery(in, new MultiplicativeBoostValuesSource(new QueryBoostValuesSource(DoubleValuesSource.fromQuery(boostMatch), boostValue)));
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        Weight inner = this.in.createWeight(searcher, needsScores && this.source.needsScores(), 1.0f);
        if (!needsScores) {
            return inner;
        }
        return new FunctionScoreWeight(this, inner, this.source.rewrite(searcher), boost);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return this;
        }
        return new FunctionScoreQuery(rewritten, this.source);
    }

    @Override
    public String toString(String field) {
        return "FunctionScoreQuery(" + this.in.toString(field) + ", scored by " + this.source.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery that = (FunctionScoreQuery)o;
        return Objects.equals(this.in, that.in) && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.source);
    }

    private static class QueryBoostValuesSource
    extends DoubleValuesSource {
        private final DoubleValuesSource query;
        private final float boost;

        QueryBoostValuesSource(DoubleValuesSource query, float boost) {
            this.query = query;
            this.boost = boost;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final DoubleValues in = this.query.getValues(ctx, null);
            return DoubleValues.withDefault(new DoubleValues(){

                @Override
                public double doubleValue() {
                    return boost;
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            }, 1.0);
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return new QueryBoostValuesSource(this.query.rewrite(reader), this.boost);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryBoostValuesSource that = (QueryBoostValuesSource)o;
            return Float.compare(that.boost, this.boost) == 0 && Objects.equals(this.query, that.query);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.query, Float.valueOf(this.boost));
        }

        @Override
        public String toString() {
            return "queryboost(" + this.query + ")^" + this.boost;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.query.isCacheable(ctx);
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            Explanation inner = this.query.explain(ctx, docId, scoreExplanation);
            if (!inner.isMatch()) {
                return inner;
            }
            return Explanation.match(this.boost, "Matched boosting query " + this.query.toString(), new Explanation[0]);
        }
    }

    private static class MultiplicativeBoostValuesSource
    extends DoubleValuesSource {
        private final DoubleValuesSource boost;

        private MultiplicativeBoostValuesSource(DoubleValuesSource boost) {
            this.boost = boost;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            final DoubleValues in = DoubleValues.withDefault(this.boost.getValues(ctx, scores), 1.0);
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return scores.doubleValue() * in.doubleValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return new MultiplicativeBoostValuesSource(this.boost.rewrite(reader));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiplicativeBoostValuesSource that = (MultiplicativeBoostValuesSource)o;
            return Objects.equals(this.boost, that.boost);
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            if (!scoreExplanation.isMatch()) {
                return scoreExplanation;
            }
            Explanation boostExpl = this.boost.explain(ctx, docId, scoreExplanation);
            if (!boostExpl.isMatch()) {
                return scoreExplanation;
            }
            return Explanation.match(scoreExplanation.getValue() * boostExpl.getValue(), "product of:", scoreExplanation, boostExpl);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.boost);
        }

        @Override
        public String toString() {
            return "boost(" + this.boost.toString() + ")";
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.boost.isCacheable(ctx);
        }
    }

    private static class FunctionScoreWeight
    extends Weight {
        final Weight inner;
        final DoubleValuesSource valueSource;
        final float boost;

        FunctionScoreWeight(Query query, Weight inner, DoubleValuesSource valueSource, float boost) {
            super(query);
            this.inner = inner;
            this.valueSource = valueSource;
            this.boost = boost;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.inner.extractTerms(terms);
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            return this.inner.matches(context, doc);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.inner.scorer(context);
            if (scorer.iterator().advance(doc) != doc) {
                return Explanation.noMatch("No match", new Explanation[0]);
            }
            Explanation scoreExplanation = this.inner.explain(context, doc);
            Explanation expl = this.valueSource.explain(context, doc, scoreExplanation);
            return Explanation.match(expl.getValue() * this.boost, "product of:", Explanation.match(this.boost, "boost", new Explanation[0]), expl);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer in = this.inner.scorer(context);
            if (in == null) {
                return null;
            }
            final DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer(in));
            return new FilterScorer(in){

                @Override
                public float score() throws IOException {
                    if (scores.advanceExact(this.docID())) {
                        return (float)(scores.doubleValue() * (double)boost);
                    }
                    return 0.0f;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.inner.isCacheable(ctx) && this.valueSource.isCacheable(ctx);
        }
    }
}

