/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.mapper;

import conductor.com.carrotsearch.hppc.ObjectArrayList;
import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.IndexableField;
import conductor.org.apache.lucene.index.IndexableFieldType;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.DocValuesFieldExistsQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TermQuery;
import conductor.org.apache.lucene.store.ByteArrayDataOutput;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.CollectionUtils;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.plain.BytesBinaryDVIndexFieldData;
import conductor.org.elasticsearch.index.mapper.CustomDocValuesField;
import conductor.org.elasticsearch.index.mapper.FieldMapper;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.Mapper;
import conductor.org.elasticsearch.index.mapper.MapperParsingException;
import conductor.org.elasticsearch.index.mapper.ParseContext;
import conductor.org.elasticsearch.index.mapper.TypeParsers;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.index.query.QueryShardException;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.joda.time.DateTimeZone;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class BinaryFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "binary";

    protected BinaryFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (!this.fieldType().stored() && !this.fieldType().hasDocValues()) {
            return;
        }
        byte[] value = context.parseExternalValue(byte[].class);
        if (value == null) {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().binaryValue();
        }
        if (value == null) {
            return;
        }
        if (this.fieldType().stored()) {
            fields.add(new Field(this.fieldType().name(), value, (IndexableFieldType)this.fieldType()));
        }
        if (this.fieldType().hasDocValues()) {
            CustomBinaryDocValuesField field = (CustomBinaryDocValuesField)context.doc().getByKey(this.fieldType().name());
            if (field == null) {
                field = new CustomBinaryDocValuesField(this.fieldType().name(), value);
                context.doc().addWithKey(this.fieldType().name(), field);
            } else {
                field.add(value);
            }
        } else {
            this.createFieldNamesField(context, fields);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class CustomBinaryDocValuesField
    extends CustomDocValuesField {
        private final ObjectArrayList<byte[]> bytesList = new ObjectArrayList();
        private int totalSize = 0;

        public CustomBinaryDocValuesField(String name, byte[] bytes) {
            super(name);
            this.add(bytes);
        }

        public void add(byte[] bytes) {
            this.bytesList.add(bytes);
            this.totalSize += bytes.length;
        }

        @Override
        public BytesRef binaryValue() {
            try {
                CollectionUtils.sortAndDedup(this.bytesList);
                int size = this.bytesList.size();
                byte[] bytes = new byte[this.totalSize + (size + 1) * 5];
                ByteArrayDataOutput out = new ByteArrayDataOutput(bytes);
                out.writeVInt(size);
                for (int i = 0; i < size; ++i) {
                    byte[] value = this.bytesList.get(i);
                    int valueLength = value.length;
                    out.writeVInt(valueLength);
                    out.writeBytes(value, 0, valueLength);
                }
                return new BytesRef(bytes, 0, out.getPosition());
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get binary value", (Throwable)e, new Object[0]);
            }
        }
    }

    static final class BinaryFieldType
    extends MappedFieldType {
        BinaryFieldType() {
        }

        protected BinaryFieldType(BinaryFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new BinaryFieldType(this);
        }

        @Override
        public String typeName() {
            return BinaryFieldMapper.CONTENT_TYPE;
        }

        @Override
        public DocValueFormat docValueFormat(String format, DateTimeZone timeZone) {
            return DocValueFormat.BINARY;
        }

        @Override
        public BytesReference valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesReference bytes = value instanceof BytesRef ? new BytesArray((BytesRef)value) : (value instanceof BytesReference ? (BytesReference)value : (value instanceof byte[] ? new BytesArray((byte[])value) : new BytesArray(Base64.getDecoder().decode(value.toString()))));
            return bytes;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new BytesBinaryDVIndexFieldData.Builder();
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Binary fields do not support searching", new Object[0]);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, BinaryFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public BinaryFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new BinaryFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new BinaryFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

