/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.document;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.get.GetRequest;
import conductor.org.elasticsearch.action.get.GetResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestResponseListener;
import conductor.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;

public class RestGetSourceAction
extends BaseRestHandler {
    public RestGetSourceAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_source", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}/_source", this);
    }

    @Override
    public String getName() {
        return "document_get_source_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.parent(request.param("parent"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> {
            if (getRequest.fetchSourceContext() != null && !getRequest.fetchSourceContext().fetchSource()) {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("fetching source can not be disabled");
                channel.sendResponse(new BytesRestResponse((RestChannel)channel, validationError));
            } else {
                client.get(getRequest, (ActionListener<GetResponse>)new RestResponseListener<GetResponse>(channel){

                    @Override
                    public RestResponse buildResponse(GetResponse response) throws Exception {
                        XContentBuilder builder = this.channel.newBuilder(request.getXContentType(), false);
                        if (response.isSourceEmpty()) {
                            return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                        }
                        BytesReference source = response.getSourceInternal();
                        try (StreamInput stream = source.streamInput();){
                            builder.rawValue(stream, XContentHelper.xContentType(source));
                        }
                        return new BytesRestResponse(RestStatus.OK, builder);
                    }
                });
            }
        };
    }
}

