/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.nested;

import conductor.org.elasticsearch.index.mapper.ObjectMapper;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.NonCollectingAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.nested.InternalReverseNested;
import conductor.org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ReverseNestedAggregatorFactory
extends AggregatorFactory<ReverseNestedAggregatorFactory> {
    private final boolean unmapped;
    private final ObjectMapper parentObjectMapper;

    public ReverseNestedAggregatorFactory(String name, boolean unmapped, ObjectMapper parentObjectMapper, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactories, metaData);
        this.unmapped = unmapped;
        this.parentObjectMapper = parentObjectMapper;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (this.unmapped) {
            return new Unmapped(this.name, this.context, parent, pipelineAggregators, metaData);
        }
        return new ReverseNestedAggregator(this.name, this.factories, this.parentObjectMapper, this.context, parent, pipelineAggregators, metaData);
    }

    private static final class Unmapped
    extends NonCollectingAggregator {
        Unmapped(String name, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, context, parent, pipelineAggregators, metaData);
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
        }
    }
}

