/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.terms;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.util.NumericUtils;
import conductor.org.elasticsearch.index.fielddata.FieldData;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.BucketOrder;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DoubleTermsAggregator
extends LongTermsAggregator {
    DoubleTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, IncludeExclude.LongFilter longFilter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, valuesSource, format, order, bucketCountThresholds, aggregationContext, parent, collectionMode, showTermDocCountError, longFilter, pipelineAggregators, metaData);
    }

    @Override
    protected SortedNumericDocValues getValues(ValuesSource.Numeric valuesSource, LeafReaderContext ctx) throws IOException {
        return FieldData.toSortableLongBits(valuesSource.doubleValues(ctx));
    }

    @Override
    public DoubleTerms buildAggregation(long owningBucketOrdinal) throws IOException {
        LongTerms terms = (LongTerms)super.buildAggregation(owningBucketOrdinal);
        return DoubleTermsAggregator.convertToDouble(terms);
    }

    @Override
    public DoubleTerms buildEmptyAggregation() {
        LongTerms terms = (LongTerms)super.buildEmptyAggregation();
        return DoubleTermsAggregator.convertToDouble(terms);
    }

    private static DoubleTerms convertToDouble(LongTerms terms) {
        List<DoubleTerms.Bucket> buckets = terms.buckets.stream().map(DoubleTermsAggregator::convertToDouble).collect(Collectors.toList());
        return new DoubleTerms(terms.getName(), terms.order, terms.requiredSize, terms.minDocCount, terms.pipelineAggregators(), terms.getMetaData(), terms.format, terms.shardSize, terms.showTermDocCountError, terms.otherDocCount, buckets, terms.docCountError);
    }

    private static DoubleTerms.Bucket convertToDouble(LongTerms.Bucket bucket) {
        double value = NumericUtils.sortableLongToDouble(bucket.term);
        return new DoubleTerms.Bucket(value, bucket.docCount, bucket.aggregations, bucket.showDocCountError, bucket.docCountError, bucket.format);
    }
}

