/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.internal;

import conductor.org.apache.lucene.index.DirectoryReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.TermContext;
import conductor.org.apache.lucene.search.BulkScorer;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.Collector;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.QueryCache;
import conductor.org.apache.lucene.search.QueryCachingPolicy;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.index.engine.Engine;
import conductor.org.elasticsearch.search.dfs.AggregatedDfs;
import conductor.org.elasticsearch.search.internal.CancellableBulkScorer;
import conductor.org.elasticsearch.search.profile.Timer;
import conductor.org.elasticsearch.search.profile.query.ProfileWeight;
import conductor.org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import conductor.org.elasticsearch.search.profile.query.QueryProfiler;
import conductor.org.elasticsearch.search.profile.query.QueryTimingType;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class ContextIndexSearcher
extends IndexSearcher
implements Releasable {
    private final IndexSearcher in;
    private AggregatedDfs aggregatedDfs;
    private final Engine.Searcher engineSearcher;
    private QueryProfiler profiler;
    private Runnable checkCancelled;

    public ContextIndexSearcher(Engine.Searcher searcher, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy) {
        super(searcher.reader());
        this.in = searcher.searcher();
        this.engineSearcher = searcher;
        this.setSimilarity(searcher.searcher().getSimilarity(true));
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
    }

    @Override
    public void close() {
    }

    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public void setCheckCancelled(Runnable checkCancelled) {
        this.checkCancelled = checkCancelled;
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        if (this.profiler != null) {
            this.profiler.startRewriteTime();
        }
        try {
            Query query = this.in.rewrite(original);
            return query;
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime();
            }
        }
    }

    @Override
    public Weight createNormalizedWeight(Query query, boolean needsScores) throws IOException {
        if (this.aggregatedDfs != null && needsScores) {
            return super.createNormalizedWeight(query, needsScores);
        }
        if (this.profiler != null) {
            return super.createNormalizedWeight(query, needsScores);
        }
        return this.in.createNormalizedWeight(query, needsScores);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Weight createWeight(Query query, boolean needsScores, float boost) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            QueryProfileBreakdown profile = (QueryProfileBreakdown)this.profiler.getQueryBreakdown(query);
            Timer timer = profile.getTimer(QueryTimingType.CREATE_WEIGHT);
            timer.start();
            try {
                weight = super.createWeight(query, needsScores, boost);
            }
            finally {
                timer.stop();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, needsScores, boost);
    }

    @Override
    protected void search(List<LeafReaderContext> leaves, final Weight weight, Collector collector) throws IOException {
        Weight cancellableWeight = this.checkCancelled != null ? new Weight(weight.getQuery()){

            @Override
            public void extractTerms(Set<Term> terms) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                BulkScorer in = weight.bulkScorer(context);
                if (in != null) {
                    return new CancellableBulkScorer(in, ContextIndexSearcher.this.checkCancelled);
                }
                return null;
            }
        } : weight;
        super.search(leaves, cancellableWeight, collector);
    }

    @Override
    public Explanation explain(Query query, int doc) throws IOException {
        if (this.aggregatedDfs != null) {
            return super.explain(this.createNormalizedWeight(query, true), doc);
        }
        return this.in.explain(query, doc);
    }

    @Override
    public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.termStatistics(term, context);
        }
        TermStatistics termStatistics = this.aggregatedDfs.termStatistics().get(term);
        if (termStatistics == null) {
            return super.termStatistics(term, context);
        }
        return termStatistics;
    }

    @Override
    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = this.aggregatedDfs.fieldStatistics().get(field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    public DirectoryReader getDirectoryReader() {
        return this.engineSearcher.getDirectoryReader();
    }
}

