/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.profile.aggregation;

import conductor.org.apache.lucene.search.Scorer;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.profile.Timer;
import conductor.org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import conductor.org.elasticsearch.search.profile.aggregation.AggregationTimingType;
import java.io.IOException;

public class ProfilingLeafBucketCollector
extends LeafBucketCollector {
    private LeafBucketCollector delegate;
    private Timer collectTimer;

    public ProfilingLeafBucketCollector(LeafBucketCollector delegate, AggregationProfileBreakdown profileBreakdown) {
        this.delegate = delegate;
        this.collectTimer = profileBreakdown.getTimer(AggregationTimingType.COLLECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(int doc, long bucket) throws IOException {
        this.collectTimer.start();
        try {
            this.delegate.collect(doc, bucket);
        }
        finally {
            this.collectTimer.stop();
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }
}

