/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch.es6;

import com.google.inject.AbstractModule;
import com.netflix.conductor.dao.IndexDAO;
import com.netflix.conductor.dao.es6.index.ElasticSearchDAOV6;
import com.netflix.conductor.dao.es6.index.ElasticSearchRestDAOV6;
import com.netflix.conductor.elasticsearch.ElasticSearchConfiguration;
import com.netflix.conductor.elasticsearch.EmbeddedElasticSearchProvider;
import com.netflix.conductor.elasticsearch.es6.EmbeddedElasticSearchV6Provider;
import java.util.HashSet;

public class ElasticSearchV6Module
extends AbstractModule {
    private boolean restTransport;

    public ElasticSearchV6Module(ElasticSearchConfiguration elasticSearchConfiguration) {
        HashSet<String> REST_SCHEMAS = new HashSet<String>();
        REST_SCHEMAS.add("http");
        REST_SCHEMAS.add("https");
        String esTransport = elasticSearchConfiguration.getURIs().get(0).getScheme();
        this.restTransport = REST_SCHEMAS.contains(esTransport);
    }

    protected void configure() {
        if (this.restTransport) {
            this.bind(IndexDAO.class).to(ElasticSearchRestDAOV6.class);
        } else {
            this.bind(IndexDAO.class).to(ElasticSearchDAOV6.class);
        }
        this.bind(EmbeddedElasticSearchProvider.class).to(EmbeddedElasticSearchV6Provider.class);
    }
}

