/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.carrotsearch.hppc.sorting;

import conductor.com.carrotsearch.hppc.sorting.IndirectComparator;
import java.util.Comparator;

public final class IndirectSort {
    static int MIN_LENGTH_FOR_INSERTION_SORT = 30;

    private IndirectSort() {
    }

    public static int[] mergesort(int start, int length, IndirectComparator comparator) {
        int[] src = IndirectSort.createOrderArray(start, length);
        if (length > 1) {
            int[] dst = (int[])src.clone();
            IndirectSort.topDownMergeSort(src, dst, 0, length, comparator);
            return dst;
        }
        return src;
    }

    public static <T> int[] mergesort(T[] input, int start, int length, Comparator<? super T> comparator) {
        return IndirectSort.mergesort(start, length, new IndirectComparator.DelegatingComparator<T>(input, comparator));
    }

    private static void topDownMergeSort(int[] src, int[] dst, int fromIndex, int toIndex, IndirectComparator comp) {
        if (toIndex - fromIndex <= MIN_LENGTH_FOR_INSERTION_SORT) {
            IndirectSort.insertionSort(fromIndex, toIndex - fromIndex, dst, comp);
            return;
        }
        int mid = fromIndex + toIndex >>> 1;
        IndirectSort.topDownMergeSort(dst, src, fromIndex, mid, comp);
        IndirectSort.topDownMergeSort(dst, src, mid, toIndex, comp);
        if (comp.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, fromIndex, dst, fromIndex, toIndex - fromIndex);
        } else {
            int i = fromIndex;
            int j = mid;
            for (int k = fromIndex; k < toIndex; ++k) {
                dst[k] = j == toIndex || i < mid && comp.compare(src[i], src[j]) <= 0 ? src[i++] : src[j++];
            }
        }
    }

    private static void insertionSort(int off, int len, int[] order, IndirectComparator intComparator) {
        for (int i = off + 1; i < off + len; ++i) {
            int t;
            int v = order[i];
            int j = i;
            while (j > off && intComparator.compare(t = order[j - 1], v) > 0) {
                order[j--] = t;
            }
            order[j] = v;
        }
    }

    private static int[] createOrderArray(int start, int length) {
        int[] order = new int[length];
        for (int i = 0; i < length; ++i) {
            order[i] = start + i;
        }
        return order;
    }
}

