/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.minhash;

import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.minhash.MinHashFilter;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.util.Map;

public class MinHashFilterFactory
extends TokenFilterFactory {
    private int hashCount = 1;
    private int bucketCount = 512;
    private int hashSetSize = 1;
    private boolean withRotation;

    public MinHashFilterFactory(Map<String, String> args) {
        super(args);
        this.hashCount = this.getInt(args, "hashCount", 1);
        this.bucketCount = this.getInt(args, "bucketCount", 512);
        this.hashSetSize = this.getInt(args, "hashSetSize", 1);
        this.withRotation = this.getBoolean(args, "withRotation", this.bucketCount > 1);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new MinHashFilter(input, this.hashCount, this.bucketCount, this.hashSetSize, this.withRotation);
    }
}

