/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.state;

import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.master.MasterNodeReadRequest;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;

public class ClusterStateRequest
extends MasterNodeReadRequest<ClusterStateRequest>
implements IndicesRequest.Replaceable {
    private boolean routingTable = true;
    private boolean nodes = true;
    private boolean metaData = true;
    private boolean blocks = true;
    private boolean customs = true;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandOpen();

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public ClusterStateRequest all() {
        this.routingTable = true;
        this.nodes = true;
        this.metaData = true;
        this.blocks = true;
        this.customs = true;
        this.indices = Strings.EMPTY_ARRAY;
        return this;
    }

    public ClusterStateRequest clear() {
        this.routingTable = false;
        this.nodes = false;
        this.metaData = false;
        this.blocks = false;
        this.customs = false;
        this.indices = Strings.EMPTY_ARRAY;
        return this;
    }

    public boolean routingTable() {
        return this.routingTable;
    }

    public ClusterStateRequest routingTable(boolean routingTable) {
        this.routingTable = routingTable;
        return this;
    }

    public boolean nodes() {
        return this.nodes;
    }

    public ClusterStateRequest nodes(boolean nodes) {
        this.nodes = nodes;
        return this;
    }

    public boolean metaData() {
        return this.metaData;
    }

    public ClusterStateRequest metaData(boolean metaData) {
        this.metaData = metaData;
        return this;
    }

    public boolean blocks() {
        return this.blocks;
    }

    public ClusterStateRequest blocks(boolean blocks) {
        this.blocks = blocks;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ClusterStateRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final ClusterStateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public ClusterStateRequest customs(boolean customs) {
        this.customs = customs;
        return this;
    }

    public boolean customs() {
        return this.customs;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.routingTable = in.readBoolean();
        this.nodes = in.readBoolean();
        this.metaData = in.readBoolean();
        this.blocks = in.readBoolean();
        this.customs = in.readBoolean();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.routingTable);
        out.writeBoolean(this.nodes);
        out.writeBoolean(this.metaData);
        out.writeBoolean(this.blocks);
        out.writeBoolean(this.customs);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }
}

