/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.stats;

import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.admin.cluster.stats.ClusterStatsIndices;
import conductor.org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import conductor.org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodes;
import conductor.org.elasticsearch.action.support.nodes.BaseNodesResponse;
import conductor.org.elasticsearch.cluster.ClusterName;
import conductor.org.elasticsearch.cluster.health.ClusterHealthStatus;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class ClusterStatsResponse
extends BaseNodesResponse<ClusterStatsNodeResponse>
implements ToXContentFragment {
    ClusterStatsNodes nodesStats;
    ClusterStatsIndices indicesStats;
    ClusterHealthStatus status;
    long timestamp;
    String clusterUUID;

    ClusterStatsResponse() {
    }

    public ClusterStatsResponse(long timestamp, String clusterUUID, ClusterName clusterName, List<ClusterStatsNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
        this.clusterUUID = clusterUUID;
        this.timestamp = timestamp;
        this.nodesStats = new ClusterStatsNodes(nodes);
        this.indicesStats = new ClusterStatsIndices(nodes);
        for (ClusterStatsNodeResponse response : nodes) {
            if (response.clusterStatus() == null) continue;
            this.status = response.clusterStatus();
            break;
        }
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public ClusterStatsNodes getNodesStats() {
        return this.nodesStats;
    }

    public ClusterStatsIndices getIndicesStats() {
        return this.indicesStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.timestamp = in.readVLong();
        this.status = in.readOptionalWriteable(ClusterHealthStatus::readFrom);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        out.writeOptionalWriteable(this.status);
    }

    @Override
    protected List<ClusterStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        List<ClusterStatsNodeResponse> nodes = in.readList(ClusterStatsNodeResponse::readNodeResponse);
        this.nodesStats = new ClusterStatsNodes(nodes);
        this.indicesStats = new ClusterStatsIndices(nodes);
        return nodes;
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<ClusterStatsNodeResponse> nodes) throws IOException {
        out.writeStreamableList(nodes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cluster_uuid", this.getClusterUUID());
        builder.field("timestamp", this.getTimestamp());
        if (this.status != null) {
            builder.field("status", this.status.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject("indices");
        this.indicesStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("nodes");
        this.nodesStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString(builder);
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

