/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.template.get;

import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GetIndexTemplatesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<IndexTemplateMetaData> indexTemplates;

    GetIndexTemplatesResponse() {
        this.indexTemplates = new ArrayList<IndexTemplateMetaData>();
    }

    GetIndexTemplatesResponse(List<IndexTemplateMetaData> indexTemplates) {
        this.indexTemplates = indexTemplates;
    }

    public List<IndexTemplateMetaData> getIndexTemplates() {
        return this.indexTemplates;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.indexTemplates.clear();
        for (int i = 0; i < size; ++i) {
            this.indexTemplates.add(0, IndexTemplateMetaData.readFrom(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indexTemplates.size());
        for (IndexTemplateMetaData indexTemplate : this.indexTemplates) {
            indexTemplate.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        params = new ToXContent.DelegatingMapParams(Collections.singletonMap("reduce_mappings", "true"), params);
        builder.startObject();
        for (IndexTemplateMetaData indexTemplateMetaData : this.getIndexTemplates()) {
            IndexTemplateMetaData.Builder.toXContent(indexTemplateMetaData, builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static GetIndexTemplatesResponse fromXContent(XContentParser parser) throws IOException {
        ArrayList<IndexTemplateMetaData> templates = new ArrayList<IndexTemplateMetaData>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                IndexTemplateMetaData templateMetaData = IndexTemplateMetaData.Builder.fromXContent(parser, parser.currentName());
                templates.add(templateMetaData);
            }
            token = parser.nextToken();
        }
        return new GetIndexTemplatesResponse(templates);
    }
}

