/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.get;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.get.MultiGetItemResponse;
import conductor.org.elasticsearch.action.get.MultiGetRequest;
import conductor.org.elasticsearch.action.get.MultiGetResponse;
import conductor.org.elasticsearch.action.get.MultiGetShardRequest;
import conductor.org.elasticsearch.action.get.MultiGetShardResponse;
import conductor.org.elasticsearch.action.get.TransportShardMultiGetAction;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.concurrent.AtomicArray;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TransportMultiGetAction
extends HandledTransportAction<MultiGetRequest, MultiGetResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiGetAction shardAction;

    @Inject
    public TransportMultiGetAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportShardMultiGetAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver resolver) {
        super(settings, "indices:data/read/mget", threadPool, transportService, actionFilters, resolver, MultiGetRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
    }

    @Override
    protected void doExecute(MultiGetRequest request, final ActionListener<MultiGetResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        final AtomicArray<MultiGetItemResponse> responses = new AtomicArray<MultiGetItemResponse>(request.items.size());
        HashMap<ShardId, MultiGetShardRequest> shardRequests = new HashMap<ShardId, MultiGetShardRequest>();
        for (int i = 0; i < request.items.size(); ++i) {
            String concreteSingleIndex;
            MultiGetRequest.Item item;
            block7: {
                item = request.items.get(i);
                try {
                    concreteSingleIndex = this.indexNameExpressionResolver.concreteSingleIndex(clusterState, item).getName();
                    item.routing(clusterState.metaData().resolveIndexRouting(item.parent(), item.routing(), item.index()));
                    if (item.routing() == null && clusterState.getMetaData().routingRequired(concreteSingleIndex, item.type())) {
                        String message = "routing is required for [" + concreteSingleIndex + "]/[" + item.type() + "]/[" + item.id() + "]";
                        responses.set(i, TransportMultiGetAction.newItemFailure(concreteSingleIndex, item.type(), item.id(), new IllegalArgumentException(message)));
                    }
                    break block7;
                }
                catch (Exception e) {
                    responses.set(i, TransportMultiGetAction.newItemFailure(item.index(), item.type(), item.id(), e));
                }
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().getShards(clusterState, concreteSingleIndex, item.id(), item.routing(), null).shardId();
            MultiGetShardRequest shardRequest = (MultiGetShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiGetShardRequest(request, shardId.getIndexName(), shardId.getId());
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, item);
        }
        if (shardRequests.isEmpty()) {
            listener.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
        }
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiGetShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute(shardRequest, new ActionListener<MultiGetShardResponse>(){

                @Override
                public void onResponse(MultiGetShardResponse response) {
                    for (int i = 0; i < response.locations.size(); ++i) {
                        MultiGetItemResponse itemResponse = new MultiGetItemResponse(response.responses.get(i), response.failures.get(i));
                        responses.set(response.locations.get(i), itemResponse);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    for (int i = 0; i < shardRequest.locations.size(); ++i) {
                        MultiGetRequest.Item item = shardRequest.items.get(i);
                        responses.set(shardRequest.locations.get(i), TransportMultiGetAction.newItemFailure(shardRequest.index(), item.type(), item.id(), e));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
                }
            });
        }
    }

    private static MultiGetItemResponse newItemFailure(String index, String type, String id, Exception exception) {
        return new MultiGetItemResponse(null, new MultiGetResponse.Failure(index, type, id, exception));
    }
}

