/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.OriginalIndices;
import conductor.org.elasticsearch.action.search.SearchPhase;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.SearchShardIterator;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.search.SearchShardTarget;
import conductor.org.elasticsearch.search.internal.InternalSearchResponse;
import conductor.org.elasticsearch.search.internal.ShardSearchTransportRequest;
import conductor.org.elasticsearch.transport.Transport;
import java.util.concurrent.Executor;

interface SearchPhaseContext
extends ActionListener<SearchResponse>,
Executor {
    public int getNumShards();

    public Logger getLogger();

    public SearchTask getTask();

    public SearchRequest getRequest();

    public SearchResponse buildSearchResponse(InternalSearchResponse var1, String var2);

    public void onPhaseFailure(SearchPhase var1, String var2, Throwable var3);

    public void onShardFailure(int var1, @Nullable SearchShardTarget var2, Exception var3);

    public Transport.Connection getConnection(String var1, String var2);

    public SearchTransportService getSearchTransport();

    default public void sendReleaseSearchContext(long contextId, Transport.Connection connection, OriginalIndices originalIndices) {
        if (connection != null) {
            this.getSearchTransport().sendFreeContext(connection, contextId, originalIndices);
        }
    }

    public ShardSearchTransportRequest buildShardSearchRequest(SearchShardIterator var1);

    public void executeNextPhase(SearchPhase var1, SearchPhase var2);
}

