/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ListenableActionFuture;
import conductor.org.elasticsearch.action.support.AdapterActionFuture;
import conductor.org.elasticsearch.action.support.ThreadedActionListener;
import conductor.org.elasticsearch.common.logging.Loggers;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.List;

public class PlainListenableActionFuture<T>
extends AdapterActionFuture<T, T>
implements ListenableActionFuture<T> {
    volatile Object listeners;
    boolean executedListeners = false;

    protected PlainListenableActionFuture() {
    }

    public static <T> PlainListenableActionFuture<T> newListenableFuture() {
        return new PlainListenableActionFuture<T>();
    }

    public static <T> PlainListenableActionFuture<T> newDispatchingListenableFuture(ThreadPool threadPool) {
        return new DispatchingListenableActionFuture(threadPool);
    }

    @Override
    public void addListener(ActionListener<T> listener) {
        this.internalAddListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        super.done();
        PlainListenableActionFuture plainListenableActionFuture = this;
        synchronized (plainListenableActionFuture) {
            this.executedListeners = true;
        }
        Object listeners = this.listeners;
        if (listeners != null) {
            if (listeners instanceof List) {
                List list = (List)listeners;
                for (Object listener : list) {
                    this.executeListener((ActionListener)listener);
                }
            } else {
                this.executeListener((ActionListener)listeners);
            }
        }
    }

    @Override
    protected T convert(T listenerResponse) {
        return listenerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAddListener(ActionListener<T> listener) {
        boolean executeImmediate = false;
        PlainListenableActionFuture plainListenableActionFuture = this;
        synchronized (plainListenableActionFuture) {
            if (this.executedListeners) {
                executeImmediate = true;
            } else {
                ActionListener<T> listeners = this.listeners;
                if (listeners == null) {
                    listeners = listener;
                } else if (listeners instanceof List) {
                    ((List)this.listeners).add(listener);
                } else {
                    ActionListener<T> orig = listeners;
                    listeners = new ArrayList(2);
                    ((List)((Object)listeners)).add(orig);
                    ((List)((Object)listeners)).add(listener);
                }
                this.listeners = listeners;
            }
        }
        if (executeImmediate) {
            this.executeListener(listener);
        }
    }

    private void executeListener(ActionListener<T> listener) {
        try {
            listener.onResponse(this.actionGet(0L));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static final class DispatchingListenableActionFuture<T>
    extends PlainListenableActionFuture<T> {
        private static final Logger logger = Loggers.getLogger(DispatchingListenableActionFuture.class);
        private final ThreadPool threadPool;

        private DispatchingListenableActionFuture(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void addListener(ActionListener<T> listener) {
            super.addListener(new ThreadedActionListener<T>(logger, this.threadPool, "listener", listener, false));
        }
    }
}

