/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support.broadcast;

import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.OriginalIndices;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.broadcast.BroadcastRequest;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.transport.TransportRequest;
import java.io.IOException;

public abstract class BroadcastShardRequest
extends TransportRequest
implements IndicesRequest {
    private ShardId shardId;
    protected OriginalIndices originalIndices;

    public BroadcastShardRequest() {
    }

    protected BroadcastShardRequest(ShardId shardId, BroadcastRequest request) {
        this.shardId = shardId;
        this.originalIndices = new OriginalIndices(request);
    }

    protected BroadcastShardRequest(ShardId shardId, OriginalIndices originalIndices) {
        this.shardId = shardId;
        this.originalIndices = originalIndices;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = ShardId.readShardId(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }
}

