/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support.nodes;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.NoSuchNodeException;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeResponse;
import conductor.org.elasticsearch.action.support.nodes.BaseNodesRequest;
import conductor.org.elasticsearch.action.support.nodes.BaseNodesResponse;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.NodeShouldNotConnectException;
import conductor.org.elasticsearch.transport.TransportChannel;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.TransportRequest;
import conductor.org.elasticsearch.transport.TransportRequestHandler;
import conductor.org.elasticsearch.transport.TransportRequestOptions;
import conductor.org.elasticsearch.transport.TransportResponse;
import conductor.org.elasticsearch.transport.TransportResponseHandler;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;

public abstract class TransportNodesAction<NodesRequest extends BaseNodesRequest<NodesRequest>, NodesResponse extends BaseNodesResponse, NodeRequest extends BaseNodeRequest, NodeResponse extends BaseNodeResponse>
extends HandledTransportAction<NodesRequest, NodesResponse> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final Class<NodeResponse> nodeResponseClass;
    final String transportNodeAction;

    protected TransportNodesAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<NodesRequest> request, Supplier<NodeRequest> nodeRequest, String nodeExecutor, Class<NodeResponse> nodeResponseClass) {
        super(settings, actionName, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.transportService = Objects.requireNonNull(transportService);
        this.nodeResponseClass = Objects.requireNonNull(nodeResponseClass);
        this.transportNodeAction = actionName + "[n]";
        transportService.registerRequestHandler(this.transportNodeAction, nodeRequest, nodeExecutor, new NodeTransportHandler());
    }

    @Override
    protected final void doExecute(NodesRequest request, ActionListener<NodesResponse> listener) {
        this.logger.warn("attempt to execute a transport nodes operation without a task");
        throw new UnsupportedOperationException("task parameter is required for this operation");
    }

    @Override
    protected void doExecute(Task task, NodesRequest request, ActionListener<NodesResponse> listener) {
        new AsyncAction(this, task, request, listener).start();
    }

    protected boolean transportCompress() {
        return false;
    }

    protected NodesResponse newResponse(NodesRequest request, AtomicReferenceArray nodesResponses) {
        ArrayList<BaseNodeResponse> responses = new ArrayList<BaseNodeResponse>();
        ArrayList<FailedNodeException> failures = new ArrayList<FailedNodeException>();
        for (int i = 0; i < nodesResponses.length(); ++i) {
            Object response = nodesResponses.get(i);
            if (response instanceof FailedNodeException) {
                failures.add((FailedNodeException)response);
                continue;
            }
            responses.add((BaseNodeResponse)this.nodeResponseClass.cast(response));
        }
        return this.newResponse(request, responses, failures);
    }

    protected abstract NodesResponse newResponse(NodesRequest var1, List<NodeResponse> var2, List<FailedNodeException> var3);

    protected abstract NodeRequest newNodeRequest(String var1, NodesRequest var2);

    protected abstract NodeResponse newNodeResponse();

    protected abstract NodeResponse nodeOperation(NodeRequest var1);

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        return this.nodeOperation(request);
    }

    protected void resolveRequest(NodesRequest request, ClusterState clusterState) {
        assert (((BaseNodesRequest)request).concreteNodes() == null) : "request concreteNodes shouldn't be set";
        String[] nodesIds = clusterState.nodes().resolveNodes(((BaseNodesRequest)request).nodesIds());
        ((BaseNodesRequest)request).setConcreteNodes((DiscoveryNode[])Arrays.stream(nodesIds).map(clusterState.nodes()::get).toArray(DiscoveryNode[]::new));
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeRequest> {
        NodeTransportHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel, Task task) throws Exception {
            channel.sendResponse((TransportResponse)TransportNodesAction.this.nodeOperation(request, task));
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse((TransportResponse)TransportNodesAction.this.nodeOperation(request));
        }
    }

    static class AsyncAction {
        private final NodesRequest request;
        private final ActionListener<NodesResponse> listener;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        private final Task task;
        final /* synthetic */ TransportNodesAction this$0;

        AsyncAction(Task task, NodesRequest request, ActionListener<NodesResponse> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            this.listener = listener;
            if (((BaseNodesRequest)request).concreteNodes() == null) {
                this$0.resolveRequest(request, this$0.clusterService.state());
                assert (((BaseNodesRequest)request).concreteNodes() != null);
            }
            this.responses = new AtomicReferenceArray(((BaseNodesRequest)request).concreteNodes().length);
        }

        void start() {
            DiscoveryNode[] nodes = ((BaseNodesRequest)this.request).concreteNodes();
            if (nodes.length == 0) {
                this.this$0.threadPool.generic().execute(() -> this.listener.onResponse(this.this$0.newResponse(this.request, this.responses)));
                return;
            }
            TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
            if (((BaseNodesRequest)this.request).timeout() != null) {
                builder.withTimeout(((BaseNodesRequest)this.request).timeout());
            }
            builder.withCompress(this.this$0.transportCompress());
            for (int i = 0; i < nodes.length; ++i) {
                final int idx = i;
                final DiscoveryNode node = nodes[i];
                String nodeId = node.getId();
                try {
                    if (node == null) {
                        this.onFailure(idx, nodeId, new NoSuchNodeException(nodeId));
                        continue;
                    }
                    Object nodeRequest = this.this$0.newNodeRequest(nodeId, this.request);
                    if (this.task != null) {
                        nodeRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                    }
                    this.this$0.transportService.sendRequest(node, this.this$0.transportNodeAction, (TransportRequest)nodeRequest, builder.build(), new TransportResponseHandler<NodeResponse>(){

                        @Override
                        public NodeResponse newInstance() {
                            return AsyncAction.this.this$0.newNodeResponse();
                        }

                        @Override
                        public void handleResponse(NodeResponse response) {
                            AsyncAction.this.onOperation(idx, response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            AsyncAction.this.onFailure(idx, node.getId(), exp);
                        }

                        @Override
                        public String executor() {
                            return "same";
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    this.onFailure(idx, nodeId, e);
                }
            }
        }

        private void onOperation(int idx, NodeResponse nodeResponse) {
            this.responses.set(idx, nodeResponse);
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, String nodeId, Throwable t) {
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug(new ParameterizedMessage("failed to execute on node [{}]", (Object)nodeId), t);
            }
            this.responses.set(idx, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t));
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void finishHim() {
            Object finalResponse;
            try {
                finalResponse = this.this$0.newResponse(this.request, this.responses);
            }
            catch (Exception e) {
                this.this$0.logger.debug("failed to combine responses from nodes", (Throwable)e);
                this.listener.onFailure(e);
                return;
            }
            this.listener.onResponse(finalResponse);
        }
    }
}

