/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.apache.http.HttpEntity;
import conductor.org.apache.http.entity.ByteArrayEntity;
import conductor.org.apache.http.entity.ContentType;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.action.DocWriteRequest;
import conductor.org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import conductor.org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import conductor.org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import conductor.org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import conductor.org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import conductor.org.elasticsearch.action.bulk.BulkRequest;
import conductor.org.elasticsearch.action.delete.DeleteRequest;
import conductor.org.elasticsearch.action.explain.ExplainRequest;
import conductor.org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import conductor.org.elasticsearch.action.get.GetRequest;
import conductor.org.elasticsearch.action.get.MultiGetRequest;
import conductor.org.elasticsearch.action.index.IndexRequest;
import conductor.org.elasticsearch.action.search.ClearScrollRequest;
import conductor.org.elasticsearch.action.search.MultiSearchRequest;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchScrollRequest;
import conductor.org.elasticsearch.action.support.ActiveShardCount;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.WriteRequest;
import conductor.org.elasticsearch.action.update.UpdateRequest;
import conductor.org.elasticsearch.client.Request;
import conductor.org.elasticsearch.client.Requests;
import conductor.org.elasticsearch.client.RethrottleRequest;
import conductor.org.elasticsearch.client.security.RefreshPolicy;
import conductor.org.elasticsearch.cluster.health.ClusterHealthStatus;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Priority;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.SuppressForbidden;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.DeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.VersionType;
import conductor.org.elasticsearch.index.rankeval.RankEvalRequest;
import conductor.org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import conductor.org.elasticsearch.index.reindex.DeleteByQueryRequest;
import conductor.org.elasticsearch.index.reindex.ReindexRequest;
import conductor.org.elasticsearch.index.reindex.UpdateByQueryRequest;
import conductor.org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import conductor.org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import conductor.org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import conductor.org.elasticsearch.script.mustache.SearchTemplateRequest;
import conductor.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import conductor.org.elasticsearch.tasks.TaskId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringJoiner;

final class RequestConverters {
    static final XContentType REQUEST_BODY_CONTENT_TYPE = XContentType.JSON;

    private RequestConverters() {
    }

    static Request delete(DeleteRequest deleteRequest) {
        String endpoint = RequestConverters.endpoint(deleteRequest.index(), deleteRequest.type(), deleteRequest.id());
        Request request = new Request("DELETE", endpoint);
        Params parameters = new Params(request);
        parameters.withRouting(deleteRequest.routing());
        parameters.withParent(deleteRequest.parent());
        parameters.withTimeout(deleteRequest.timeout());
        parameters.withVersion(deleteRequest.version());
        parameters.withVersionType(deleteRequest.versionType());
        parameters.withRefreshPolicy(deleteRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(deleteRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        return request;
    }

    static Request info() {
        return new Request("GET", "/");
    }

    static Request bulk(BulkRequest bulkRequest) throws IOException {
        Request request = new Request("POST", "/_bulk");
        Params parameters = new Params(request);
        parameters.withTimeout(bulkRequest.timeout());
        parameters.withRefreshPolicy(bulkRequest.getRefreshPolicy());
        XContentType bulkContentType = null;
        for (int i = 0; i < bulkRequest.numberOfActions(); ++i) {
            DocWriteRequest<?> action = bulkRequest.requests().get(i);
            DocWriteRequest.OpType opType = action.opType();
            if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                bulkContentType = RequestConverters.enforceSameContentType((IndexRequest)action, bulkContentType);
                continue;
            }
            if (opType != DocWriteRequest.OpType.UPDATE) continue;
            UpdateRequest updateRequest = (UpdateRequest)action;
            if (updateRequest.doc() != null) {
                bulkContentType = RequestConverters.enforceSameContentType(updateRequest.doc(), bulkContentType);
            }
            if (updateRequest.upsertRequest() == null) continue;
            bulkContentType = RequestConverters.enforceSameContentType(updateRequest.upsertRequest(), bulkContentType);
        }
        if (bulkContentType == null) {
            bulkContentType = XContentType.JSON;
        }
        byte separator = bulkContentType.xContent().streamSeparator();
        ContentType requestContentType = RequestConverters.createContentType(bulkContentType);
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        for (DocWriteRequest<?> action : bulkRequest.requests()) {
            BytesRef source;
            block44: {
                DocWriteRequest.OpType opType = action.opType();
                try (XContentBuilder metadata = XContentBuilder.builder(bulkContentType.xContent());){
                    VersionType versionType;
                    metadata.startObject();
                    metadata.startObject(opType.getLowercase());
                    if (Strings.hasLength(action.index())) {
                        metadata.field("_index", action.index());
                    }
                    if (Strings.hasLength(action.type())) {
                        metadata.field("_type", action.type());
                    }
                    if (Strings.hasLength(action.id())) {
                        metadata.field("_id", action.id());
                    }
                    if (Strings.hasLength(action.routing())) {
                        metadata.field("routing", action.routing());
                    }
                    if (Strings.hasLength(action.parent())) {
                        metadata.field("parent", action.parent());
                    }
                    if (action.version() != -3L) {
                        metadata.field("version", action.version());
                    }
                    if ((versionType = action.versionType()) != VersionType.INTERNAL) {
                        if (versionType == VersionType.EXTERNAL) {
                            metadata.field("version_type", "external");
                        } else if (versionType == VersionType.EXTERNAL_GTE) {
                            metadata.field("version_type", "external_gte");
                        } else if (versionType == VersionType.FORCE) {
                            metadata.field("version_type", "force");
                        }
                    }
                    if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                        IndexRequest indexRequest = (IndexRequest)action;
                        if (Strings.hasLength(indexRequest.getPipeline())) {
                            metadata.field("pipeline", indexRequest.getPipeline());
                        }
                    } else if (opType == DocWriteRequest.OpType.UPDATE) {
                        UpdateRequest updateRequest = (UpdateRequest)action;
                        if (updateRequest.retryOnConflict() > 0) {
                            metadata.field("retry_on_conflict", updateRequest.retryOnConflict());
                        }
                        if (updateRequest.fetchSource() != null) {
                            metadata.field("_source", updateRequest.fetchSource());
                        }
                    }
                    metadata.endObject();
                    metadata.endObject();
                    BytesRef metadataSource = BytesReference.bytes(metadata).toBytesRef();
                    content.write(metadataSource.bytes, metadataSource.offset, metadataSource.length);
                    content.write(separator);
                }
                source = null;
                if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                    IndexRequest indexRequest = (IndexRequest)action;
                    BytesReference indexSource = indexRequest.source();
                    XContentType indexXContentType = indexRequest.getContentType();
                    try (XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, indexSource, indexXContentType);
                         XContentBuilder builder = XContentBuilder.builder(bulkContentType.xContent());){
                        builder.copyCurrentStructure(parser);
                        source = BytesReference.bytes(builder).toBytesRef();
                        break block44;
                    }
                }
                if (opType == DocWriteRequest.OpType.UPDATE) {
                    source = XContentHelper.toXContent((UpdateRequest)action, bulkContentType, false).toBytesRef();
                }
            }
            if (source == null) continue;
            content.write(source.bytes, source.offset, source.length);
            content.write(separator);
        }
        request.setEntity(new ByteArrayEntity(content.toByteArray(), 0, content.size(), requestContentType));
        return request;
    }

    static Request exists(GetRequest getRequest) {
        return RequestConverters.getStyleRequest("HEAD", getRequest);
    }

    static Request get(GetRequest getRequest) {
        return RequestConverters.getStyleRequest("GET", getRequest);
    }

    private static Request getStyleRequest(String method, GetRequest getRequest) {
        Request request = new Request(method, RequestConverters.endpoint(getRequest.index(), getRequest.type(), getRequest.id()));
        Params parameters = new Params(request);
        parameters.withPreference(getRequest.preference());
        parameters.withRouting(getRequest.routing());
        parameters.withParent(getRequest.parent());
        parameters.withRefresh(getRequest.refresh());
        parameters.withRealtime(getRequest.realtime());
        parameters.withStoredFields(getRequest.storedFields());
        parameters.withVersion(getRequest.version());
        parameters.withVersionType(getRequest.versionType());
        parameters.withFetchSourceContext(getRequest.fetchSourceContext());
        return request;
    }

    static Request multiGet(MultiGetRequest multiGetRequest) throws IOException {
        Request request = new Request("POST", "/_mget");
        Params parameters = new Params(request);
        parameters.withPreference(multiGetRequest.preference());
        parameters.withRealtime(multiGetRequest.realtime());
        parameters.withRefresh(multiGetRequest.refresh());
        request.setEntity(RequestConverters.createEntity(multiGetRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request index(IndexRequest indexRequest) {
        String method = Strings.hasLength(indexRequest.id()) ? "PUT" : "POST";
        boolean isCreate = indexRequest.opType() == DocWriteRequest.OpType.CREATE;
        String endpoint = RequestConverters.endpoint(indexRequest.index(), indexRequest.type(), indexRequest.id(), isCreate ? "_create" : null);
        Request request = new Request(method, endpoint);
        Params parameters = new Params(request);
        parameters.withRouting(indexRequest.routing());
        parameters.withParent(indexRequest.parent());
        parameters.withTimeout(indexRequest.timeout());
        parameters.withVersion(indexRequest.version());
        parameters.withVersionType(indexRequest.versionType());
        parameters.withPipeline(indexRequest.getPipeline());
        parameters.withRefreshPolicy(indexRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(indexRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        BytesRef source = indexRequest.source().toBytesRef();
        ContentType contentType = RequestConverters.createContentType(indexRequest.getContentType());
        request.setEntity(new ByteArrayEntity(source.bytes, source.offset, source.length, contentType));
        return request;
    }

    static Request ping() {
        return new Request("HEAD", "/");
    }

    static Request update(UpdateRequest updateRequest) throws IOException {
        String endpoint = RequestConverters.endpoint(updateRequest.index(), updateRequest.type(), updateRequest.id(), "_update");
        Request request = new Request("POST", endpoint);
        Params parameters = new Params(request);
        parameters.withRouting(updateRequest.routing());
        parameters.withParent(updateRequest.parent());
        parameters.withTimeout(updateRequest.timeout());
        parameters.withRefreshPolicy(updateRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(updateRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        parameters.withDocAsUpsert(updateRequest.docAsUpsert());
        parameters.withFetchSourceContext(updateRequest.fetchSource());
        parameters.withRetryOnConflict(updateRequest.retryOnConflict());
        parameters.withVersion(updateRequest.version());
        parameters.withVersionType(updateRequest.versionType());
        XContentType xContentType = null;
        if (updateRequest.doc() != null) {
            xContentType = updateRequest.doc().getContentType();
        }
        if (updateRequest.upsertRequest() != null) {
            XContentType upsertContentType = updateRequest.upsertRequest().getContentType();
            if (xContentType != null && xContentType != upsertContentType) {
                throw new IllegalStateException("Update request cannot have different content types for doc [" + (Object)((Object)xContentType) + "] and upsert [" + (Object)((Object)upsertContentType) + "] documents");
            }
            xContentType = upsertContentType;
        }
        if (xContentType == null) {
            xContentType = Requests.INDEX_CONTENT_TYPE;
        }
        request.setEntity(RequestConverters.createEntity(updateRequest, xContentType));
        return request;
    }

    static Request search(SearchRequest searchRequest) throws IOException {
        Request request = new Request("POST", RequestConverters.endpoint(searchRequest.indices(), searchRequest.types(), "_search"));
        Params params = new Params(request);
        RequestConverters.addSearchRequestParams(params, searchRequest);
        if (searchRequest.source() != null) {
            request.setEntity(RequestConverters.createEntity(searchRequest.source(), REQUEST_BODY_CONTENT_TYPE));
        }
        return request;
    }

    private static void addSearchRequestParams(Params params, SearchRequest searchRequest) {
        params.putParam("typed_keys", "true");
        params.withRouting(searchRequest.routing());
        params.withPreference(searchRequest.preference());
        params.withIndicesOptions(searchRequest.indicesOptions());
        params.putParam("search_type", searchRequest.searchType().name().toLowerCase(Locale.ROOT));
        if (searchRequest.requestCache() != null) {
            params.putParam("request_cache", Boolean.toString(searchRequest.requestCache()));
        }
        if (searchRequest.allowPartialSearchResults() != null) {
            params.putParam("allow_partial_search_results", Boolean.toString(searchRequest.allowPartialSearchResults()));
        }
        params.putParam("batched_reduce_size", Integer.toString(searchRequest.getBatchedReduceSize()));
        if (searchRequest.scroll() != null) {
            params.putParam("scroll", searchRequest.scroll().keepAlive());
        }
    }

    static Request searchScroll(SearchScrollRequest searchScrollRequest) throws IOException {
        Request request = new Request("POST", "/_search/scroll");
        request.setEntity(RequestConverters.createEntity(searchScrollRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request clearScroll(ClearScrollRequest clearScrollRequest) throws IOException {
        Request request = new Request("DELETE", "/_search/scroll");
        request.setEntity(RequestConverters.createEntity(clearScrollRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request multiSearch(MultiSearchRequest multiSearchRequest) throws IOException {
        Request request = new Request("POST", "/_msearch");
        Params params = new Params(request);
        params.putParam("typed_keys", "true");
        if (multiSearchRequest.maxConcurrentSearchRequests() != 0) {
            params.putParam("max_concurrent_searches", Integer.toString(multiSearchRequest.maxConcurrentSearchRequests()));
        }
        XContent xContent = REQUEST_BODY_CONTENT_TYPE.xContent();
        byte[] source = MultiSearchRequest.writeMultiLineFormat(multiSearchRequest, xContent);
        request.setEntity(new ByteArrayEntity(source, RequestConverters.createContentType(xContent.type())));
        return request;
    }

    static Request searchTemplate(SearchTemplateRequest searchTemplateRequest) throws IOException {
        Request request;
        if (searchTemplateRequest.isSimulate()) {
            request = new Request("GET", "_render/template");
        } else {
            SearchRequest searchRequest = searchTemplateRequest.getRequest();
            String endpoint = RequestConverters.endpoint(searchRequest.indices(), searchRequest.types(), "_search/template");
            request = new Request("GET", endpoint);
            Params params = new Params(request);
            RequestConverters.addSearchRequestParams(params, searchRequest);
        }
        request.setEntity(RequestConverters.createEntity(searchTemplateRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request multiSearchTemplate(MultiSearchTemplateRequest multiSearchTemplateRequest) throws IOException {
        Request request = new Request("POST", "/_msearch/template");
        Params params = new Params(request);
        params.putParam("typed_keys", "true");
        if (multiSearchTemplateRequest.maxConcurrentSearchRequests() != 0) {
            params.putParam("max_concurrent_searches", Integer.toString(multiSearchTemplateRequest.maxConcurrentSearchRequests()));
        }
        XContent xContent = REQUEST_BODY_CONTENT_TYPE.xContent();
        byte[] source = MultiSearchTemplateRequest.writeMultiLineFormat(multiSearchTemplateRequest, xContent);
        request.setEntity(new ByteArrayEntity(source, RequestConverters.createContentType(xContent.type())));
        return request;
    }

    static Request explain(ExplainRequest explainRequest) throws IOException {
        Request request = new Request("GET", RequestConverters.endpoint(explainRequest.index(), explainRequest.type(), explainRequest.id(), "_explain"));
        Params params = new Params(request);
        params.withStoredFields(explainRequest.storedFields());
        params.withFetchSourceContext(explainRequest.fetchSourceContext());
        params.withRouting(explainRequest.routing());
        params.withPreference(explainRequest.preference());
        request.setEntity(RequestConverters.createEntity(explainRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request fieldCaps(FieldCapabilitiesRequest fieldCapabilitiesRequest) {
        String[] indices = fieldCapabilitiesRequest.indices();
        Request request = new Request("GET", RequestConverters.endpoint(indices, "_field_caps"));
        Params params = new Params(request);
        params.withFields(fieldCapabilitiesRequest.fields());
        params.withIndicesOptions(fieldCapabilitiesRequest.indicesOptions());
        return request;
    }

    static Request rankEval(RankEvalRequest rankEvalRequest) throws IOException {
        Request request = new Request("GET", RequestConverters.endpoint(rankEvalRequest.indices(), Strings.EMPTY_ARRAY, "_rank_eval"));
        Params params = new Params(request);
        params.withIndicesOptions(rankEvalRequest.indicesOptions());
        request.setEntity(RequestConverters.createEntity(rankEvalRequest.getRankEvalSpec(), REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request reindex(ReindexRequest reindexRequest) throws IOException {
        String endpoint = new EndpointBuilder().addPathPart("_reindex").build();
        Request request = new Request("POST", endpoint);
        Params params = new Params(request).withRefresh(reindexRequest.isRefresh()).withTimeout(reindexRequest.getTimeout()).withWaitForActiveShards(reindexRequest.getWaitForActiveShards(), ActiveShardCount.DEFAULT).withRequestsPerSecond(reindexRequest.getRequestsPerSecond());
        if (reindexRequest.getScrollTime() != null) {
            params.putParam("scroll", reindexRequest.getScrollTime());
        }
        request.setEntity(RequestConverters.createEntity(reindexRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request updateByQuery(UpdateByQueryRequest updateByQueryRequest) throws IOException {
        String endpoint = RequestConverters.endpoint(updateByQueryRequest.indices(), updateByQueryRequest.getDocTypes(), "_update_by_query");
        Request request = new Request("POST", endpoint);
        Params params = new Params(request).withRouting(updateByQueryRequest.getRouting()).withPipeline(updateByQueryRequest.getPipeline()).withRefresh(updateByQueryRequest.isRefresh()).withTimeout(updateByQueryRequest.getTimeout()).withWaitForActiveShards(updateByQueryRequest.getWaitForActiveShards(), ActiveShardCount.DEFAULT).withRequestsPerSecond(updateByQueryRequest.getRequestsPerSecond()).withIndicesOptions(updateByQueryRequest.indicesOptions());
        if (!updateByQueryRequest.isAbortOnVersionConflict()) {
            params.putParam("conflicts", "proceed");
        }
        if (updateByQueryRequest.getBatchSize() != 1000) {
            params.putParam("scroll_size", Integer.toString(updateByQueryRequest.getBatchSize()));
        }
        if (updateByQueryRequest.getScrollTime() != AbstractBulkByScrollRequest.DEFAULT_SCROLL_TIMEOUT) {
            params.putParam("scroll", updateByQueryRequest.getScrollTime());
        }
        if (updateByQueryRequest.getSize() > 0) {
            params.putParam("size", Integer.toString(updateByQueryRequest.getSize()));
        }
        request.setEntity(RequestConverters.createEntity(updateByQueryRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteByQuery(DeleteByQueryRequest deleteByQueryRequest) throws IOException {
        String endpoint = RequestConverters.endpoint(deleteByQueryRequest.indices(), deleteByQueryRequest.getDocTypes(), "_delete_by_query");
        Request request = new Request("POST", endpoint);
        Params params = new Params(request).withRouting(deleteByQueryRequest.getRouting()).withRefresh(deleteByQueryRequest.isRefresh()).withTimeout(deleteByQueryRequest.getTimeout()).withWaitForActiveShards(deleteByQueryRequest.getWaitForActiveShards(), ActiveShardCount.DEFAULT).withRequestsPerSecond(deleteByQueryRequest.getRequestsPerSecond()).withIndicesOptions(deleteByQueryRequest.indicesOptions());
        if (!deleteByQueryRequest.isAbortOnVersionConflict()) {
            params.putParam("conflicts", "proceed");
        }
        if (deleteByQueryRequest.getBatchSize() != 1000) {
            params.putParam("scroll_size", Integer.toString(deleteByQueryRequest.getBatchSize()));
        }
        if (deleteByQueryRequest.getScrollTime() != AbstractBulkByScrollRequest.DEFAULT_SCROLL_TIMEOUT) {
            params.putParam("scroll", deleteByQueryRequest.getScrollTime());
        }
        if (deleteByQueryRequest.getSize() > 0) {
            params.putParam("size", Integer.toString(deleteByQueryRequest.getSize()));
        }
        request.setEntity(RequestConverters.createEntity(deleteByQueryRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request rethrottleReindex(RethrottleRequest rethrottleRequest) {
        return RequestConverters.rethrottle(rethrottleRequest, "_reindex");
    }

    static Request rethrottleUpdateByQuery(RethrottleRequest rethrottleRequest) {
        return RequestConverters.rethrottle(rethrottleRequest, "_update_by_query");
    }

    static Request rethrottleDeleteByQuery(RethrottleRequest rethrottleRequest) {
        return RequestConverters.rethrottle(rethrottleRequest, "_delete_by_query");
    }

    private static Request rethrottle(RethrottleRequest rethrottleRequest, String firstPathPart) {
        String endpoint = new EndpointBuilder().addPathPart(firstPathPart).addPathPart(rethrottleRequest.getTaskId().toString()).addPathPart("_rethrottle").build();
        Request request = new Request("POST", endpoint);
        Params params = new Params(request).withRequestsPerSecond(rethrottleRequest.getRequestsPerSecond());
        params.putParam("group_by", "none");
        return request;
    }

    static Request putScript(PutStoredScriptRequest putStoredScriptRequest) throws IOException {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(putStoredScriptRequest.id()).build();
        Request request = new Request("POST", endpoint);
        Params params = new Params(request);
        params.withTimeout(putStoredScriptRequest.timeout());
        params.withMasterTimeout(putStoredScriptRequest.masterNodeTimeout());
        if (Strings.hasText(putStoredScriptRequest.context())) {
            params.putParam("context", putStoredScriptRequest.context());
        }
        request.setEntity(RequestConverters.createEntity(putStoredScriptRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request analyze(AnalyzeRequest request) throws IOException {
        EndpointBuilder builder = new EndpointBuilder();
        String index = request.index();
        if (index != null) {
            builder.addPathPart(index);
        }
        builder.addPathPartAsIs("_analyze");
        Request req = new Request("GET", builder.build());
        req.setEntity(RequestConverters.createEntity(request, REQUEST_BODY_CONTENT_TYPE));
        return req;
    }

    static Request getScript(GetStoredScriptRequest getStoredScriptRequest) {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(getStoredScriptRequest.id()).build();
        Request request = new Request("GET", endpoint);
        Params params = new Params(request);
        params.withMasterTimeout(getStoredScriptRequest.masterNodeTimeout());
        return request;
    }

    static Request deleteScript(DeleteStoredScriptRequest deleteStoredScriptRequest) {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(deleteStoredScriptRequest.id()).build();
        Request request = new Request("DELETE", endpoint);
        Params params = new Params(request);
        params.withTimeout(deleteStoredScriptRequest.timeout());
        params.withMasterTimeout(deleteStoredScriptRequest.masterNodeTimeout());
        return request;
    }

    static Request xPackWatcherPutWatch(PutWatchRequest putWatchRequest) {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("watch").addPathPart(putWatchRequest.getId()).build();
        Request request = new Request("PUT", endpoint);
        Params params = new Params(request).withVersion(putWatchRequest.getVersion());
        if (!putWatchRequest.isActive()) {
            params.putParam("active", "false");
        }
        ContentType contentType = RequestConverters.createContentType(putWatchRequest.xContentType());
        BytesReference source = putWatchRequest.getSource();
        request.setEntity(new ByteArrayEntity(source.toBytesRef().bytes, 0, source.length(), contentType));
        return request;
    }

    static Request xPackWatcherDeleteWatch(DeleteWatchRequest deleteWatchRequest) {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("watch").addPathPart(deleteWatchRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        return request;
    }

    static HttpEntity createEntity(ToXContent toXContent, XContentType xContentType) throws IOException {
        BytesRef source = XContentHelper.toXContent(toXContent, xContentType, false).toBytesRef();
        return new ByteArrayEntity(source.bytes, source.offset, source.length, RequestConverters.createContentType(xContentType));
    }

    static String endpoint(String index, String type, String id) {
        return new EndpointBuilder().addPathPart(index, type, id).build();
    }

    static String endpoint(String index, String type, String id, String endpoint) {
        return new EndpointBuilder().addPathPart(index, type, id).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).build();
    }

    static String endpoint(String[] indices, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String[] types, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addCommaSeparatedPathParts(types).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String endpoint, String[] suffixes) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addCommaSeparatedPathParts(suffixes).build();
    }

    static String endpoint(String[] indices, String endpoint, String type) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addPathPart(type).build();
    }

    @SuppressForbidden(reason="Only allowed place to convert a XContentType to a ContentType")
    public static ContentType createContentType(XContentType xContentType) {
        return ContentType.create(xContentType.mediaTypeWithoutParameters(), (Charset)null);
    }

    static XContentType enforceSameContentType(IndexRequest indexRequest, @Nullable XContentType xContentType) {
        XContentType requestContentType = indexRequest.getContentType();
        if (requestContentType != XContentType.JSON && requestContentType != XContentType.SMILE) {
            throw new IllegalArgumentException("Unsupported content-type found for request with content-type [" + (Object)((Object)requestContentType) + "], only JSON and SMILE are supported");
        }
        if (xContentType == null) {
            return requestContentType;
        }
        if (requestContentType != xContentType) {
            throw new IllegalArgumentException("Mismatching content-type found for request with content-type [" + (Object)((Object)requestContentType) + "], previous requests have content-type [" + (Object)((Object)xContentType) + "]");
        }
        return xContentType;
    }

    static class EndpointBuilder {
        private final StringJoiner joiner = new StringJoiner("/", "/", "");

        EndpointBuilder() {
        }

        EndpointBuilder addPathPart(String ... parts) {
            for (String part : parts) {
                if (!Strings.hasLength(part)) continue;
                this.joiner.add(EndpointBuilder.encodePart(part));
            }
            return this;
        }

        EndpointBuilder addCommaSeparatedPathParts(String[] parts) {
            this.addPathPart(String.join((CharSequence)",", parts));
            return this;
        }

        EndpointBuilder addPathPartAsIs(String ... parts) {
            for (String part : parts) {
                if (!Strings.hasLength(part)) continue;
                this.joiner.add(part);
            }
            return this;
        }

        String build() {
            return this.joiner.toString();
        }

        private static String encodePart(String pathPart) {
            try {
                URI uri = new URI(null, null, null, -1, "/" + pathPart, null, null);
                return uri.getRawPath().substring(1).replaceAll("/", "%2F");
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Path part [" + pathPart + "] couldn't be encoded", e);
            }
        }
    }

    static class Params {
        private final Request request;

        Params(Request request) {
            this.request = request;
        }

        Params putParam(String name, String value) {
            if (Strings.hasLength(value)) {
                this.request.addParameter(name, value);
            }
            return this;
        }

        Params putParam(String key, TimeValue value) {
            if (value != null) {
                return this.putParam(key, value.getStringRep());
            }
            return this;
        }

        Params withDocAsUpsert(boolean docAsUpsert) {
            if (docAsUpsert) {
                return this.putParam("doc_as_upsert", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withFetchSourceContext(FetchSourceContext fetchSourceContext) {
            if (fetchSourceContext != null) {
                if (!fetchSourceContext.fetchSource()) {
                    this.putParam("_source", Boolean.FALSE.toString());
                }
                if (fetchSourceContext.includes() != null && fetchSourceContext.includes().length > 0) {
                    this.putParam("_source_include", String.join((CharSequence)",", fetchSourceContext.includes()));
                }
                if (fetchSourceContext.excludes() != null && fetchSourceContext.excludes().length > 0) {
                    this.putParam("_source_exclude", String.join((CharSequence)",", fetchSourceContext.excludes()));
                }
            }
            return this;
        }

        Params withFields(String[] fields) {
            if (fields != null && fields.length > 0) {
                return this.putParam("fields", String.join((CharSequence)",", fields));
            }
            return this;
        }

        Params withMasterTimeout(TimeValue masterTimeout) {
            return this.putParam("master_timeout", masterTimeout);
        }

        Params withParent(String parent) {
            return this.putParam("parent", parent);
        }

        Params withPipeline(String pipeline) {
            return this.putParam("pipeline", pipeline);
        }

        Params withPreference(String preference) {
            return this.putParam("preference", preference);
        }

        Params withRealtime(boolean realtime) {
            if (!realtime) {
                return this.putParam("realtime", Boolean.FALSE.toString());
            }
            return this;
        }

        Params withRefresh(boolean refresh) {
            if (refresh) {
                return this.withRefreshPolicy(RefreshPolicy.IMMEDIATE);
            }
            return this;
        }

        @Deprecated
        Params withRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            if (refreshPolicy != WriteRequest.RefreshPolicy.NONE) {
                return this.putParam("refresh", refreshPolicy.getValue());
            }
            return this;
        }

        Params withRefreshPolicy(RefreshPolicy refreshPolicy) {
            if (refreshPolicy != RefreshPolicy.NONE) {
                return this.putParam("refresh", refreshPolicy.getValue());
            }
            return this;
        }

        Params withRequestsPerSecond(float requestsPerSecond) {
            if (Float.isFinite(requestsPerSecond)) {
                return this.putParam("requests_per_second", Float.toString(requestsPerSecond));
            }
            return this.putParam("requests_per_second", "-1");
        }

        Params withRetryOnConflict(int retryOnConflict) {
            if (retryOnConflict > 0) {
                return this.putParam("retry_on_conflict", String.valueOf(retryOnConflict));
            }
            return this;
        }

        Params withRouting(String routing) {
            return this.putParam("routing", routing);
        }

        Params withStoredFields(String[] storedFields) {
            if (storedFields != null && storedFields.length > 0) {
                return this.putParam("stored_fields", String.join((CharSequence)",", storedFields));
            }
            return this;
        }

        Params withTimeout(TimeValue timeout) {
            return this.putParam("timeout", timeout);
        }

        Params withUpdateAllTypes(boolean updateAllTypes) {
            if (updateAllTypes) {
                return this.putParam("update_all_types", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withVersion(long version) {
            if (version != -3L) {
                return this.putParam("version", Long.toString(version));
            }
            return this;
        }

        Params withVersionType(VersionType versionType) {
            if (versionType != VersionType.INTERNAL) {
                return this.putParam("version_type", versionType.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withWaitForActiveShards(ActiveShardCount currentActiveShardCount, ActiveShardCount defaultActiveShardCount) {
            if (currentActiveShardCount != null && currentActiveShardCount != defaultActiveShardCount) {
                return this.putParam("wait_for_active_shards", currentActiveShardCount.toString().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withIndicesOptions(IndicesOptions indicesOptions) {
            String expandWildcards;
            this.withIgnoreUnavailable(indicesOptions.ignoreUnavailable());
            this.putParam("allow_no_indices", Boolean.toString(indicesOptions.allowNoIndices()));
            if (!indicesOptions.expandWildcardsOpen() && !indicesOptions.expandWildcardsClosed()) {
                expandWildcards = "none";
            } else {
                StringJoiner joiner = new StringJoiner(",");
                if (indicesOptions.expandWildcardsOpen()) {
                    joiner.add("open");
                }
                if (indicesOptions.expandWildcardsClosed()) {
                    joiner.add("closed");
                }
                expandWildcards = joiner.toString();
            }
            this.putParam("expand_wildcards", expandWildcards);
            return this;
        }

        Params withIgnoreUnavailable(boolean ignoreUnavailable) {
            this.putParam("ignore_unavailable", Boolean.toString(ignoreUnavailable));
            return this;
        }

        Params withHuman(boolean human) {
            if (human) {
                this.putParam("human", Boolean.toString(human));
            }
            return this;
        }

        Params withLocal(boolean local) {
            if (local) {
                this.putParam("local", Boolean.toString(local));
            }
            return this;
        }

        Params withIncludeDefaults(boolean includeDefaults) {
            if (includeDefaults) {
                return this.putParam("include_defaults", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withPreserveExisting(boolean preserveExisting) {
            if (preserveExisting) {
                return this.putParam("preserve_existing", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withDetailed(boolean detailed) {
            if (detailed) {
                return this.putParam("detailed", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForCompletion(boolean waitForCompletion) {
            if (waitForCompletion) {
                return this.putParam("wait_for_completion", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withNodes(String[] nodes) {
            if (nodes != null && nodes.length > 0) {
                return this.putParam("nodes", String.join((CharSequence)",", nodes));
            }
            return this;
        }

        Params withActions(String[] actions) {
            if (actions != null && actions.length > 0) {
                return this.putParam("actions", String.join((CharSequence)",", actions));
            }
            return this;
        }

        Params withTaskId(TaskId taskId) {
            if (taskId != null && taskId.isSet()) {
                return this.putParam("task_id", taskId.toString());
            }
            return this;
        }

        Params withParentTaskId(TaskId parentTaskId) {
            if (parentTaskId != null && parentTaskId.isSet()) {
                return this.putParam("parent_task_id", parentTaskId.toString());
            }
            return this;
        }

        Params withVerify(boolean verify) {
            if (verify) {
                return this.putParam("verify", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForStatus(ClusterHealthStatus status) {
            if (status != null) {
                return this.putParam("wait_for_status", status.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withWaitForNoRelocatingShards(boolean waitNoRelocatingShards) {
            if (waitNoRelocatingShards) {
                return this.putParam("wait_for_no_relocating_shards", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForNoInitializingShards(boolean waitNoInitShards) {
            if (waitNoInitShards) {
                return this.putParam("wait_for_no_initializing_shards", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForNodes(String waitForNodes) {
            return this.putParam("wait_for_nodes", waitForNodes);
        }

        Params withLevel(ClusterHealthRequest.Level level) {
            return this.putParam("level", level.name().toLowerCase(Locale.ROOT));
        }

        Params withWaitForEvents(Priority waitForEvents) {
            if (waitForEvents != null) {
                return this.putParam("wait_for_events", waitForEvents.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }
    }
}

