/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster;

import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.elasticsearch.cluster.DiskUsage;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;

public class ClusterInfo
implements ToXContentFragment,
Writeable {
    private final ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsage;
    private final ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsage;
    final ImmutableOpenMap<String, Long> shardSizes;
    public static final ClusterInfo EMPTY = new ClusterInfo();
    final ImmutableOpenMap<ShardRouting, String> routingToDataPath;

    protected ClusterInfo() {
        this(ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of());
    }

    public ClusterInfo(ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsage, ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsage, ImmutableOpenMap<String, Long> shardSizes, ImmutableOpenMap<ShardRouting, String> routingToDataPath) {
        this.leastAvailableSpaceUsage = leastAvailableSpaceUsage;
        this.shardSizes = shardSizes;
        this.mostAvailableSpaceUsage = mostAvailableSpaceUsage;
        this.routingToDataPath = routingToDataPath;
    }

    public ClusterInfo(StreamInput in) throws IOException {
        Map<String, DiskUsage> leastMap = in.readMap(StreamInput::readString, DiskUsage::new);
        Map<String, DiskUsage> mostMap = in.readMap(StreamInput::readString, DiskUsage::new);
        Map<String, Long> sizeMap = in.readMap(StreamInput::readString, StreamInput::readLong);
        Map<ShardRouting, String> routingMap = in.readMap(ShardRouting::new, StreamInput::readString);
        ImmutableOpenMap.Builder<String, DiskUsage> leastBuilder = ImmutableOpenMap.builder();
        this.leastAvailableSpaceUsage = leastBuilder.putAll(leastMap).build();
        ImmutableOpenMap.Builder<String, DiskUsage> mostBuilder = ImmutableOpenMap.builder();
        this.mostAvailableSpaceUsage = mostBuilder.putAll(mostMap).build();
        ImmutableOpenMap.Builder<String, Long> sizeBuilder = ImmutableOpenMap.builder();
        this.shardSizes = sizeBuilder.putAll(sizeMap).build();
        ImmutableOpenMap.Builder<ShardRouting, String> routingBuilder = ImmutableOpenMap.builder();
        this.routingToDataPath = routingBuilder.putAll(routingMap).build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.leastAvailableSpaceUsage.size());
        for (ObjectObjectCursor<String, DiskUsage> objectObjectCursor : this.leastAvailableSpaceUsage) {
            out.writeString((String)objectObjectCursor.key);
            ((DiskUsage)objectObjectCursor.value).writeTo(out);
        }
        out.writeVInt(this.mostAvailableSpaceUsage.size());
        for (ObjectObjectCursor<String, DiskUsage> objectObjectCursor : this.mostAvailableSpaceUsage) {
            out.writeString((String)objectObjectCursor.key);
            ((DiskUsage)objectObjectCursor.value).writeTo(out);
        }
        out.writeVInt(this.shardSizes.size());
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.shardSizes) {
            out.writeString((String)objectObjectCursor.key);
            if (objectObjectCursor.value == null) {
                out.writeLong(-1L);
                continue;
            }
            out.writeLong((Long)objectObjectCursor.value);
        }
        out.writeVInt(this.routingToDataPath.size());
        for (ObjectObjectCursor<Object, Object> objectObjectCursor : this.routingToDataPath) {
            ((ShardRouting)objectObjectCursor.key).writeTo(out);
            out.writeString((String)objectObjectCursor.value);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (ObjectObjectCursor<String, DiskUsage> objectObjectCursor : this.leastAvailableSpaceUsage) {
            builder.startObject((String)objectObjectCursor.key);
            builder.field("node_name", ((DiskUsage)objectObjectCursor.value).getNodeName());
            builder.startObject("least_available");
            ((DiskUsage)objectObjectCursor.value).toShortXContent(builder);
            builder.endObject();
            builder.startObject("most_available");
            DiskUsage most = this.mostAvailableSpaceUsage.get((String)objectObjectCursor.key);
            if (most != null) {
                most.toShortXContent(builder);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        builder.startObject("shard_sizes");
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.shardSizes) {
            builder.humanReadableField((String)objectObjectCursor.key + "_bytes", (String)objectObjectCursor.key, new ByteSizeValue((Long)objectObjectCursor.value));
        }
        builder.endObject();
        builder.startObject("shard_paths");
        for (ObjectObjectCursor<Object, Object> objectObjectCursor : this.routingToDataPath) {
            builder.field(((ShardRouting)objectObjectCursor.key).toString(), (String)objectObjectCursor.value);
        }
        builder.endObject();
        return builder;
    }

    public ImmutableOpenMap<String, DiskUsage> getNodeLeastAvailableDiskUsages() {
        return this.leastAvailableSpaceUsage;
    }

    public ImmutableOpenMap<String, DiskUsage> getNodeMostAvailableDiskUsages() {
        return this.mostAvailableSpaceUsage;
    }

    public Long getShardSize(ShardRouting shardRouting) {
        return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(shardRouting));
    }

    public String getDataPath(ShardRouting shardRouting) {
        return this.routingToDataPath.get(shardRouting);
    }

    public long getShardSize(ShardRouting shardRouting, long defaultValue) {
        Long shardSize = this.getShardSize(shardRouting);
        return shardSize == null ? defaultValue : shardSize;
    }

    static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return shardRouting.shardId().toString() + "[" + (shardRouting.primary() ? "p" : "r") + "]";
    }
}

