/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import java.io.IOException;
import java.util.Objects;

public class ClusterName
implements Writeable {
    public static final Setting<ClusterName> CLUSTER_NAME_SETTING = new Setting<ClusterName>("cluster.name", "elasticsearch", s -> {
        if (s.isEmpty()) {
            throw new IllegalArgumentException("[cluster.name] must not be empty");
        }
        return new ClusterName((String)s);
    }, Setting.Property.NodeScope);
    public static final ClusterName DEFAULT = CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY);
    private final String value;

    public ClusterName(StreamInput input) throws IOException {
        this(input.readString());
    }

    public ClusterName(String value) {
        this.value = value.intern();
    }

    public String value() {
        return this.value;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterName that = (ClusterName)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Cluster [" + this.value + "]";
    }
}

