/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.routing.allocation.decider;

import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.routing.RoutingNode;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.routing.UnassignedInfo;
import conductor.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import conductor.org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import conductor.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;

public class MaxRetryAllocationDecider
extends AllocationDecider {
    public static final Setting<Integer> SETTING_ALLOCATION_MAX_RETRY = Setting.intSetting("index.allocation.max_retries", 5, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String NAME = "max_retry";

    public MaxRetryAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision decision;
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        if (unassignedInfo != null && unassignedInfo.getNumFailedAllocations() > 0) {
            IndexMetaData indexMetaData = allocation.metaData().getIndexSafe(shardRouting.index());
            int maxRetry = SETTING_ALLOCATION_MAX_RETRY.get(indexMetaData.getSettings());
            decision = unassignedInfo.getNumFailedAllocations() >= maxRetry ? allocation.decision(Decision.NO, NAME, "shard has exceeded the maximum number of retries [%d] on failed allocation attempts - manually call [/_cluster/reroute?retry_failed=true] to retry, [%s]", maxRetry, unassignedInfo.toString()) : allocation.decision(Decision.YES, NAME, "shard has failed allocating [%d] times but [%d] retries are allowed", unassignedInfo.getNumFailedAllocations(), maxRetry);
        } else {
            decision = allocation.decision(Decision.YES, NAME, "shard has no previous failures", new Object[0]);
        }
        return decision;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + shardRouting;
        return this.canAllocate(shardRouting, node, allocation);
    }
}

