/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.blobstore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BlobPath
implements Iterable<String> {
    private static final String SEPARATOR = "/";
    private final List<String> paths;

    public BlobPath() {
        this.paths = Collections.emptyList();
    }

    public static BlobPath cleanPath() {
        return new BlobPath();
    }

    private BlobPath(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public Iterator<String> iterator() {
        return this.paths.iterator();
    }

    public String[] toArray() {
        return this.paths.toArray(new String[this.paths.size()]);
    }

    public BlobPath add(String path) {
        ArrayList<String> paths = new ArrayList<String>(this.paths);
        paths.add(path);
        return new BlobPath(Collections.unmodifiableList(paths));
    }

    public String buildAsString() {
        String p = String.join((CharSequence)SEPARATOR, this.paths);
        if (p.isEmpty() || p.endsWith(SEPARATOR)) {
            return p;
        }
        return p + SEPARATOR;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String path : this.paths) {
            sb.append('[').append(path).append(']');
        }
        return sb.toString();
    }
}

