/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject;

import conductor.org.elasticsearch.common.inject.Initializables;
import conductor.org.elasticsearch.common.inject.InjectorImpl;
import conductor.org.elasticsearch.common.inject.InternalFactoryToProviderAdapter;
import conductor.org.elasticsearch.common.inject.Key;
import conductor.org.elasticsearch.common.inject.Provider;
import conductor.org.elasticsearch.common.inject.ProviderToInternalFactoryAdapter;
import conductor.org.elasticsearch.common.inject.Scope;
import conductor.org.elasticsearch.common.inject.internal.Errors;
import conductor.org.elasticsearch.common.inject.internal.InternalFactory;
import conductor.org.elasticsearch.common.inject.internal.Scoping;
import java.lang.annotation.Annotation;
import java.util.Locale;

public class Scopes {
    public static final Scope SINGLETON = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            return new Provider<T>(){
                private volatile T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public T get() {
                    if (this.instance != null) return this.instance;
                    Class<InjectorImpl> clazz = InjectorImpl.class;
                    synchronized (InjectorImpl.class) {
                        if (this.instance != null) return this.instance;
                        this.instance = creator.get();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return this.instance;
                    }
                }

                public String toString() {
                    return String.format(Locale.ROOT, "%s[%s]", creator, SINGLETON);
                }
            };
        }

        @Override
        public String toString() {
            return "Scopes.SINGLETON";
        }
    };
    public static final Scope NO_SCOPE = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            return unscoped;
        }

        @Override
        public String toString() {
            return "Scopes.NO_SCOPE";
        }
    };

    private Scopes() {
    }

    static <T> InternalFactory<? extends T> scope(Key<T> key, InjectorImpl injector, InternalFactory<? extends T> creator, Scoping scoping) {
        if (scoping.isNoScope()) {
            return creator;
        }
        Scope scope = scoping.getScopeInstance();
        Provider<? extends T> scoped = scope.scope(key, new ProviderToInternalFactoryAdapter<T>(injector, creator));
        return new InternalFactoryToProviderAdapter<T>(Initializables.of(scoped));
    }

    static Scoping makeInjectable(Scoping scoping, InjectorImpl injector, Errors errors) {
        Class<? extends Annotation> scopeAnnotation = scoping.getScopeAnnotation();
        if (scopeAnnotation == null) {
            return scoping;
        }
        Scope scope = injector.state.getScope(scopeAnnotation);
        if (scope != null) {
            return Scoping.forInstance(scope);
        }
        errors.scopeNotFound(scopeAnnotation);
        return Scoping.UNSCOPED;
    }
}

