/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.io.stream;

import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.bytes.PagedBytesReference;
import conductor.org.elasticsearch.common.io.stream.BytesStream;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.ByteArray;
import java.io.IOException;

public class BytesStreamOutput
extends BytesStream {
    protected final BigArrays bigArrays;
    protected ByteArray bytes;
    protected int count;

    public BytesStreamOutput() {
        this(0);
    }

    public BytesStreamOutput(int expectedSize) {
        this(expectedSize, BigArrays.NON_RECYCLING_INSTANCE);
    }

    protected BytesStreamOutput(int expectedSize, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        this.bytes = bigArrays.newByteArray(expectedSize);
    }

    @Override
    public long position() throws IOException {
        return this.count;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.ensureCapacity((long)this.count + 1L);
        this.bytes.set(this.count, b);
        ++this.count;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (b.length < offset + length) {
            throw new IllegalArgumentException("Illegal offset " + offset + "/length " + length + " for byte[] of length " + b.length);
        }
        this.ensureCapacity((long)this.count + (long)length);
        this.bytes.set(this.count, b, offset, length);
        this.count += length;
    }

    @Override
    public void reset() {
        if (this.bytes.size() > 16384L) {
            this.bytes = this.bigArrays.resize(this.bytes, 16384L);
        }
        this.count = 0;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void seek(long position) {
        this.ensureCapacity(position);
        this.count = (int)position;
    }

    public void skip(int length) {
        this.seek((long)this.count + (long)length);
    }

    @Override
    public void close() {
    }

    public int size() {
        return this.count;
    }

    @Override
    public BytesReference bytes() {
        return new PagedBytesReference(this.bigArrays, this.bytes, this.count);
    }

    public long ramBytesUsed() {
        return this.bytes.ramBytesUsed();
    }

    void ensureCapacity(long offset) {
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " cannot hold more than 2GB of data");
        }
        this.bytes = this.bigArrays.grow(this.bytes, offset);
    }
}

