/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.http;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.transport.BoundTransportAddress;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;

public class HttpInfo
implements Writeable,
ToXContentFragment {
    private final BoundTransportAddress address;
    private final long maxContentLength;

    public HttpInfo(StreamInput in) throws IOException {
        this.address = BoundTransportAddress.readBoundTransportAddress(in);
        this.maxContentLength = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        out.writeLong(this.maxContentLength);
    }

    public HttpInfo(BoundTransportAddress address, long maxContentLength) {
        this.address = address;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("http");
        builder.array("bound_address", this.address.boundAddresses());
        builder.field("publish_address", this.address.publishAddress().toString());
        builder.humanReadableField("max_content_length_in_bytes", "max_content_length", this.maxContentLength());
        builder.endObject();
        return builder;
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    public ByteSizeValue maxContentLength() {
        return new ByteSizeValue(this.maxContentLength);
    }

    public ByteSizeValue getMaxContentLength() {
        return this.maxContentLength();
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String BOUND_ADDRESS = "bound_address";
        static final String PUBLISH_ADDRESS = "publish_address";
        static final String MAX_CONTENT_LENGTH = "max_content_length";
        static final String MAX_CONTENT_LENGTH_IN_BYTES = "max_content_length_in_bytes";

        Fields() {
        }
    }
}

