/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import conductor.org.elasticsearch.index.analysis.CharFilterFactory;
import conductor.org.elasticsearch.index.analysis.CustomAnalyzer;
import conductor.org.elasticsearch.index.analysis.MultiTermAwareComponent;
import conductor.org.elasticsearch.index.analysis.TokenFilterFactory;
import conductor.org.elasticsearch.index.analysis.TokenizerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CustomNormalizerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final Settings analyzerSettings;
    private CustomAnalyzer customAnalyzer;

    public CustomNormalizerProvider(IndexSettings indexSettings, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
    }

    public void build(String tokenizerName, TokenizerFactory tokenizerFactory, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        if (this.analyzerSettings.get("tokenizer") != null) {
            throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] cannot configure a tokenizer");
        }
        List<String> charFilterNames = this.analyzerSettings.getAsList("char_filter");
        ArrayList<CharFilterFactory> charFiltersList = new ArrayList<CharFilterFactory>(charFilterNames.size());
        for (String charFilterName : charFilterNames) {
            CharFilterFactory charFilter = charFilters.get(charFilterName);
            if (charFilter == null) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] failed to find char_filter under name [" + charFilterName + "]");
            }
            if (!(charFilter instanceof MultiTermAwareComponent)) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] may not use char filter [" + charFilterName + "]");
            }
            charFilter = (CharFilterFactory)((MultiTermAwareComponent)((Object)charFilter)).getMultiTermComponent();
            charFiltersList.add(charFilter);
        }
        List<String> tokenFilterNames = this.analyzerSettings.getAsList("filter");
        ArrayList<TokenFilterFactory> tokenFilterList = new ArrayList<TokenFilterFactory>(tokenFilterNames.size());
        for (String tokenFilterName : tokenFilterNames) {
            TokenFilterFactory tokenFilter = tokenFilters.get(tokenFilterName);
            if (tokenFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find filter under name [" + tokenFilterName + "]");
            }
            if (!(tokenFilter instanceof MultiTermAwareComponent)) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] may not use filter [" + tokenFilterName + "]");
            }
            tokenFilter = (TokenFilterFactory)((MultiTermAwareComponent)((Object)tokenFilter)).getMultiTermComponent();
            tokenFilterList.add(tokenFilter);
        }
        this.customAnalyzer = new CustomAnalyzer(tokenizerName, tokenizerFactory, charFiltersList.toArray(new CharFilterFactory[charFiltersList.size()]), tokenFilterList.toArray(new TokenFilterFactory[tokenFilterList.size()]));
    }

    @Override
    public CustomAnalyzer get() {
        return this.customAnalyzer;
    }
}

