/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.lucene.index.DocValues;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import conductor.org.elasticsearch.index.fielddata.FieldData;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;

public abstract class AbstractAtomicOrdinalsFieldData
implements AtomicOrdinalsFieldData {
    public static final Function<SortedSetDocValues, ScriptDocValues<?>> DEFAULT_SCRIPT_FUNCTION = ((Function<SortedSetDocValues, SortedBinaryDocValues>)FieldData::toString).andThen(ScriptDocValues.Strings::new);
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;

    protected AbstractAtomicOrdinalsFieldData(Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        this.scriptFunction = scriptFunction;
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        return this.scriptFunction.apply(this.getOrdinalsValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getOrdinalsValues());
    }

    public static AtomicOrdinalsFieldData empty() {
        return new AbstractAtomicOrdinalsFieldData((Function)DEFAULT_SCRIPT_FUNCTION){

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            @Override
            public void close() {
            }

            @Override
            public SortedSetDocValues getOrdinalsValues() {
                return DocValues.emptySortedSet();
            }
        };
    }
}

