/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import conductor.org.elasticsearch.index.fielddata.FieldData;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import java.util.Collection;
import java.util.Collections;

abstract class AtomicDoubleFieldData
implements AtomicNumericFieldData {
    private final long ramBytesUsed;

    AtomicDoubleFieldData(long ramBytesUsed) {
        this.ramBytesUsed = ramBytesUsed;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public final ScriptDocValues getScriptValues() {
        return new ScriptDocValues.Doubles(this.getDoubleValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getDoubleValues());
    }

    @Override
    public final SortedNumericDocValues getLongValues() {
        return FieldData.castToLong(this.getDoubleValues());
    }

    public static AtomicNumericFieldData empty(int maxDoc) {
        return new AtomicDoubleFieldData(0L){

            @Override
            public SortedNumericDoubleValues getDoubleValues() {
                return FieldData.emptySortedNumericDoubles();
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    public void close() {
    }
}

