/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.apache.lucene.util.Accountables;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.PagedBytes;
import conductor.org.apache.lucene.util.packed.PackedLongValues;
import conductor.org.elasticsearch.index.fielddata.ordinals.Ordinals;
import conductor.org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class PagedBytesAtomicFieldData
extends AbstractAtomicOrdinalsFieldData {
    private final PagedBytes.Reader bytes;
    private final PackedLongValues termOrdToBytesOffset;
    protected final Ordinals ordinals;

    public PagedBytesAtomicFieldData(PagedBytes.Reader bytes, PackedLongValues termOrdToBytesOffset, Ordinals ordinals) {
        super(DEFAULT_SCRIPT_FUNCTION);
        this.bytes = bytes;
        this.termOrdToBytesOffset = termOrdToBytesOffset;
        this.ordinals = ordinals;
    }

    @Override
    public void close() {
    }

    @Override
    public long ramBytesUsed() {
        long size = this.ordinals.ramBytesUsed();
        size += this.bytes.ramBytesUsed();
        return size += this.termOrdToBytesOffset.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.add(Accountables.namedAccountable("ordinals", this.ordinals));
        resources.add(Accountables.namedAccountable("term bytes", this.bytes));
        resources.add(Accountables.namedAccountable("term offsets", this.termOrdToBytesOffset));
        return Collections.unmodifiableList(resources);
    }

    @Override
    public SortedSetDocValues getOrdinalsValues() {
        return this.ordinals.ordinals(new ValuesHolder(this.bytes, this.termOrdToBytesOffset));
    }

    private static class ValuesHolder
    implements Ordinals.ValuesHolder {
        private final BytesRef scratch = new BytesRef();
        private final PagedBytes.Reader bytes;
        private final PackedLongValues termOrdToBytesOffset;

        ValuesHolder(PagedBytes.Reader bytes, PackedLongValues termOrdToBytesOffset) {
            this.bytes = bytes;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            assert (ord >= 0L);
            this.bytes.fill(this.scratch, this.termOrdToBytesOffset.get(ord));
            return this.scratch;
        }
    }
}

