/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNodes;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.settings.ClusterSettings;
import conductor.org.elasticsearch.common.settings.IndexScopedSettings;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.settings.SettingsFilter;
import conductor.org.elasticsearch.index.reindex.BulkByScrollResponse;
import conductor.org.elasticsearch.index.reindex.BulkByScrollTask;
import conductor.org.elasticsearch.index.reindex.DeleteByQueryAction;
import conductor.org.elasticsearch.index.reindex.DeleteByQueryRequest;
import conductor.org.elasticsearch.index.reindex.ReindexAction;
import conductor.org.elasticsearch.index.reindex.ReindexRequest;
import conductor.org.elasticsearch.index.reindex.RestDeleteByQueryAction;
import conductor.org.elasticsearch.index.reindex.RestReindexAction;
import conductor.org.elasticsearch.index.reindex.RestRethrottleAction;
import conductor.org.elasticsearch.index.reindex.RestUpdateByQueryAction;
import conductor.org.elasticsearch.index.reindex.RethrottleAction;
import conductor.org.elasticsearch.index.reindex.RethrottleRequest;
import conductor.org.elasticsearch.index.reindex.TransportDeleteByQueryAction;
import conductor.org.elasticsearch.index.reindex.TransportReindexAction;
import conductor.org.elasticsearch.index.reindex.TransportRethrottleAction;
import conductor.org.elasticsearch.index.reindex.TransportUpdateByQueryAction;
import conductor.org.elasticsearch.index.reindex.UpdateByQueryAction;
import conductor.org.elasticsearch.index.reindex.UpdateByQueryRequest;
import conductor.org.elasticsearch.plugins.ActionPlugin;
import conductor.org.elasticsearch.plugins.Plugin;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestHandler;
import conductor.org.elasticsearch.tasks.Task;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class ReindexPlugin
extends Plugin
implements ActionPlugin {
    public static final String NAME = "reindex";

    @Override
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler<ReindexRequest, BulkByScrollResponse>(ReindexAction.INSTANCE, TransportReindexAction.class, new Class[0]), new ActionPlugin.ActionHandler<UpdateByQueryRequest, BulkByScrollResponse>(UpdateByQueryAction.INSTANCE, TransportUpdateByQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler<DeleteByQueryRequest, BulkByScrollResponse>(DeleteByQueryAction.INSTANCE, TransportDeleteByQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler<RethrottleRequest, ListTasksResponse>(RethrottleAction.INSTANCE, TransportRethrottleAction.class, new Class[0]));
    }

    @Override
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.singletonList(new NamedWriteableRegistry.Entry(Task.Status.class, "bulk-by-scroll", BulkByScrollTask.Status::new));
    }

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestReindexAction(settings, restController), new RestUpdateByQueryAction(settings, restController), new RestDeleteByQueryAction(settings, restController), new RestRethrottleAction(settings, restController, nodesInCluster));
    }

    @Override
    public List<Setting<?>> getSettings() {
        return Collections.singletonList(TransportReindexAction.REMOTE_CLUSTER_WHITELIST);
    }
}

