/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.persistent;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.Action;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import conductor.org.elasticsearch.action.support.master.MasterNodeRequest;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.client.ElasticsearchClient;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.persistent.NodePersistentTasksExecutor;
import conductor.org.elasticsearch.persistent.PersistentTaskParams;
import conductor.org.elasticsearch.persistent.PersistentTaskResponse;
import conductor.org.elasticsearch.persistent.PersistentTasksClusterService;
import conductor.org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import conductor.org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import conductor.org.elasticsearch.persistent.PersistentTasksNodeService;
import conductor.org.elasticsearch.persistent.PersistentTasksService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.Objects;

public class StartPersistentTaskAction
extends Action<Request, PersistentTaskResponse, RequestBuilder> {
    public static final StartPersistentTaskAction INSTANCE = new StartPersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/start";

    private StartPersistentTaskAction() {
        super(NAME);
    }

    @Override
    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    @Override
    public PersistentTaskResponse newResponse() {
        return new PersistentTaskResponse();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, PersistentTasksExecutorRegistry persistentTasksExecutorRegistry, PersistentTasksService persistentTasksService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, StartPersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.persistentTasksClusterService = persistentTasksClusterService;
            NodePersistentTasksExecutor executor = new NodePersistentTasksExecutor(threadPool);
            clusterService.addListener(new PersistentTasksNodeService(settings, persistentTasksService, persistentTasksExecutorRegistry, transportService.getTaskManager(), executor));
        }

        @Override
        protected String executor() {
            return "generic";
        }

        @Override
        protected PersistentTaskResponse newResponse() {
            return new PersistentTaskResponse();
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void masterOperation(Request request, ClusterState state, final ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.createPersistentTask(request.taskId, request.taskName, request.params, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                @Override
                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                    listener.onResponse(new PersistentTaskResponse(task));
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, StartPersistentTaskAction action) {
            super(client, action, new Request());
        }

        public RequestBuilder setTaskId(String taskId) {
            ((Request)this.request).setTaskId(taskId);
            return this;
        }

        public RequestBuilder setAction(String action) {
            ((Request)this.request).setTaskName(action);
            return this;
        }

        public RequestBuilder setRequest(PersistentTaskParams params) {
            ((Request)this.request).setParams(params);
            return this;
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String taskId;
        private String taskName;
        private PersistentTaskParams params;

        public Request() {
        }

        public Request(String taskId, String taskName, PersistentTaskParams params) {
            this.taskId = taskId;
            this.taskName = taskName;
            this.params = params;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.taskId = in.readString();
            this.taskName = in.readString();
            this.params = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readNamedWriteable(PersistentTaskParams.class) : in.readOptionalNamedWriteable(PersistentTaskParams.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeString(this.taskName);
            if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
                out.writeNamedWriteable(this.params);
            } else {
                out.writeOptionalNamedWriteable(this.params);
            }
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError("task id must be specified", validationException);
            }
            if (this.taskName == null) {
                validationException = ValidateActions.addValidationError("action must be specified", validationException);
            }
            if (this.params != null && !this.params.getWriteableName().equals(this.taskName)) {
                validationException = ValidateActions.addValidationError("params have to have the same writeable name as task. params: " + this.params.getWriteableName() + " task: " + this.taskName, validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request1 = (Request)o;
            return Objects.equals(this.taskId, request1.taskId) && Objects.equals(this.taskName, request1.taskName) && Objects.equals(this.params, request1.params);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.taskName, this.params);
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public PersistentTaskParams getParams() {
            return this.params;
        }

        @Nullable
        public void setParams(PersistentTaskParams params) {
            this.params = params;
        }
    }
}

