/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.protocol.xpack.watcher;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.support.master.MasterNodeRequest;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import java.io.IOException;
import java.util.regex.Pattern;

public class PutWatchRequest
extends MasterNodeRequest<PutWatchRequest> {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds(10L);
    private static final Pattern NO_WS_PATTERN = Pattern.compile("\\S+");
    private String id;
    private BytesReference source;
    private XContentType xContentType = XContentType.JSON;
    private boolean active = true;
    private long version = -3L;

    public PutWatchRequest() {
    }

    public PutWatchRequest(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    public PutWatchRequest(String id, BytesReference source, XContentType xContentType) {
        this.id = id;
        this.source = source;
        this.xContentType = xContentType;
        this.masterNodeTimeout(DEFAULT_TIMEOUT);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("watch id is missing", validationException);
        } else if (!PutWatchRequest.isValidId(this.id)) {
            validationException = ValidateActions.addValidationError("watch id contains whitespace", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("watch source is missing", validationException);
        }
        if (this.xContentType == null) {
            validationException = ValidateActions.addValidationError("request body is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.active = in.readBoolean();
        this.xContentType = in.getVersion().onOrAfter(Version.V_5_3_0) ? in.readEnum(XContentType.class) : XContentHelper.xContentType(this.source);
        this.version = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readZLong() : -3L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        out.writeBoolean(this.active);
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeEnum(this.xContentType);
        }
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeZLong(this.version);
        }
    }

    public static boolean isValidId(String id) {
        return !Strings.isEmpty(id) && NO_WS_PATTERN.matcher(id).matches();
    }
}

