/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.cluster;

import conductor.org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import conductor.org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestStatusToXContentListener;
import java.io.IOException;

public class RestGetStoredScriptAction
extends BaseRestHandler {
    public RestGetStoredScriptAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_scripts/{id}", this);
    }

    @Override
    public String getName() {
        return "get_stored_scripts_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        GetStoredScriptRequest getRequest = new GetStoredScriptRequest(id);
        getRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().getStoredScript(getRequest, new RestStatusToXContentListener<GetStoredScriptResponse>((RestChannel)channel));
    }
}

