/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script.mustache;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.CompositeIndicesRequest;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.search.MultiSearchRequest;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.script.mustache.SearchTemplateRequest;
import conductor.org.elasticsearch.script.mustache.SearchTemplateRequestBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MultiSearchTemplateRequest
extends ActionRequest
implements CompositeIndicesRequest {
    private int maxConcurrentSearchRequests = 0;
    private List<SearchTemplateRequest> requests = new ArrayList<SearchTemplateRequest>();
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();

    public MultiSearchTemplateRequest add(SearchTemplateRequestBuilder request) {
        this.requests.add((SearchTemplateRequest)request.request());
        return this;
    }

    public MultiSearchTemplateRequest add(SearchTemplateRequest request) {
        this.requests.add(request);
        return this;
    }

    public int maxConcurrentSearchRequests() {
        return this.maxConcurrentSearchRequests;
    }

    public MultiSearchTemplateRequest maxConcurrentSearchRequests(int maxConcurrentSearchRequests) {
        if (maxConcurrentSearchRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentSearchRequests must be positive");
        }
        this.maxConcurrentSearchRequests = maxConcurrentSearchRequests;
        return this;
    }

    public List<SearchTemplateRequest> requests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (SearchTemplateRequest request : this.requests) {
            ActionRequestValidationException ex = request.validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiSearchTemplateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().onOrAfter(Version.V_5_5_0)) {
            this.maxConcurrentSearchRequests = in.readVInt();
        }
        this.requests = in.readStreamableList(SearchTemplateRequest::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
            out.writeVInt(this.maxConcurrentSearchRequests);
        }
        out.writeStreamableList(this.requests);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSearchTemplateRequest that = (MultiSearchTemplateRequest)o;
        return this.maxConcurrentSearchRequests == that.maxConcurrentSearchRequests && Objects.equals(this.requests, that.requests) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.maxConcurrentSearchRequests, this.requests, this.indicesOptions);
    }

    public static byte[] writeMultiLineFormat(MultiSearchTemplateRequest multiSearchTemplateRequest, XContent xContent) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (SearchTemplateRequest templateRequest : multiSearchTemplateRequest.requests()) {
            SearchRequest searchRequest = templateRequest.getRequest();
            try (XContentBuilder xContentBuilder = XContentBuilder.builder(xContent);){
                MultiSearchRequest.writeSearchRequestParams(searchRequest, xContentBuilder);
                BytesReference.bytes(xContentBuilder).writeTo(output);
            }
            output.write(xContent.streamSeparator());
            xContentBuilder = XContentBuilder.builder(xContent);
            try {
                templateRequest.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                BytesReference.bytes(xContentBuilder).writeTo(output);
            }
            finally {
                if (xContentBuilder != null) {
                    xContentBuilder.close();
                }
            }
            output.write(xContent.streamSeparator());
        }
        return output.toByteArray();
    }
}

