/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations;

import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.NamedWriteable;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public abstract class PipelineAggregationBuilder
implements NamedWriteable,
BaseAggregationBuilder,
ToXContentFragment {
    protected final String name;
    protected final String[] bucketsPaths;

    protected PipelineAggregationBuilder(String name, String[] bucketsPaths) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        if (bucketsPaths == null) {
            throw new IllegalArgumentException("[bucketsPaths] must not be null: [" + name + "]");
        }
        this.name = name;
        this.bucketsPaths = bucketsPaths;
    }

    public String getName() {
        return this.name;
    }

    public final String[] getBucketsPaths() {
        return this.bucketsPaths;
    }

    protected abstract void validate(AggregatorFactory<?> var1, Collection<AggregationBuilder> var2, Collection<PipelineAggregationBuilder> var3);

    protected abstract PipelineAggregator create() throws IOException;

    @Override
    public abstract PipelineAggregationBuilder setMetaData(Map<String, Object> var1);

    @Override
    public PipelineAggregationBuilder subAggregations(AggregatorFactories.Builder subFactories) {
        throw new IllegalArgumentException("Aggregation [" + this.name + "] cannot define sub-aggregations");
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

