/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.composite;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.mapper.DateFieldMapper;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;

public class TermsValuesSourceBuilder
extends CompositeValuesSourceBuilder<TermsValuesSourceBuilder> {
    static final String TYPE = "terms";
    private static final ObjectParser<TermsValuesSourceBuilder, Void> PARSER = new ObjectParser("terms");

    static TermsValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new TermsValuesSourceBuilder(name), null);
    }

    public TermsValuesSourceBuilder(String name) {
        super(name);
    }

    protected TermsValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    @Override
    protected int innerHashCode() {
        return 0;
    }

    @Override
    protected boolean innerEquals(TermsValuesSourceBuilder builder) {
        return true;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(SearchContext context, ValuesSourceConfig<?> config) throws IOException {
        Object vs = config.toValuesSource(context.getQueryShardContext());
        if (vs == null) {
            vs = ValuesSource.Numeric.EMPTY;
        }
        MappedFieldType fieldType = config.fieldContext() != null ? config.fieldContext().fieldType() : null;
        DocValueFormat format = this.format() == null && fieldType instanceof DateFieldMapper.DateFieldType ? DocValueFormat.RAW : config.format();
        return new CompositeValuesSourceConfig(this.name, fieldType, (ValuesSource)vs, format, this.order(), this.missingBucket(), this.missing());
    }

    static {
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER, null);
    }
}

