/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.geogrid;

import conductor.org.elasticsearch.common.geo.GeoPoint;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGrid;
import java.io.IOException;
import java.util.List;

public class ParsedGeoHashGrid
extends ParsedMultiBucketAggregation<ParsedBucket>
implements GeoHashGrid {
    private static ObjectParser<ParsedGeoHashGrid, Void> PARSER = new ObjectParser(ParsedGeoHashGrid.class.getSimpleName(), true, ParsedGeoHashGrid::new);

    @Override
    public String getType() {
        return "geohash_grid";
    }

    @Override
    public List<? extends GeoHashGrid.Bucket> getBuckets() {
        return this.buckets;
    }

    public static ParsedGeoHashGrid fromXContent(XContentParser parser, String name) throws IOException {
        ParsedGeoHashGrid aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedGeoHashGrid.declareMultiBucketAggregationFields(PARSER, ParsedBucket::fromXContent, ParsedBucket::fromXContent);
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements GeoHashGrid.Bucket {
        private String geohashAsString;

        @Override
        public GeoPoint getKey() {
            return GeoPoint.fromGeohash(this.geohashAsString);
        }

        @Override
        public String getKeyAsString() {
            return this.geohashAsString;
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.geohashAsString);
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseXContent(parser, false, ParsedBucket::new, (p, bucket) -> {
                bucket.geohashAsString = p.textOrNull();
            });
        }
    }
}

